/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import dev.gradleplugins.internal.util.FilterTransformer;
import dev.gradleplugins.internal.util.NegateSpec;
import java.util.Collections;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;

public abstract class ExportedApiExtension {
    private final ObjectFactory objects;
    private final NamedDomainObjectSet<ExportedApi> apis;

    @Inject
    public ExportedApiExtension(ObjectFactory objects) {
        this.objects = objects;
        this.apis = objects.namedDomainObjectSet(ExportedApi.class);
    }

    public NamedDomainObjectProvider<ExportedApi> forSourceSet(SourceSet sourceSet) {
        if (this.apis.findByName(sourceSet.getName()) == null) {
            this.apis.add((Object)((ExportedApi)this.objects.newInstance(ExportedApi.class, new Object[]{sourceSet})));
        }
        return this.apis.named(sourceSet.getName());
    }

    static abstract class Rule
    implements Plugin<Project> {
        @Inject
        public Rule() {
        }

        public void apply(Project project) {
            ExportedApiExtension extension = (ExportedApiExtension)project.getExtensions().create("$exportedApis", ExportedApiExtension.class, new Object[0]);
            extension.apis.configureEach(it -> {
                it.getApiSourceSet().finalizeValueOnRead();
                it.getApiSourceSet().convention((Object)it.getSourceSet());
                it.getJarTask().convention((Provider<? extends Jar>)it.getApiSourceSet().flatMap(sourceSet -> {
                    if (!project.getTasks().getNames().contains(sourceSet.getJarTaskName())) {
                        project.getTasks().register(sourceSet.getJarTaskName(), Jar.class, task -> {
                            task.setGroup("Build");
                            task.setDescription(String.format("Assemble an API jar archive for the %s classes.", sourceSet.getName()));
                            task.from(new Object[]{sourceSet.getOutput()});
                            task.getArchiveClassifier().set((Object)sourceSet.getName());
                        });
                    }
                    return project.getTasks().named(sourceSet.getJarTaskName(), Jar.class);
                }));
            });
            Rule.wirePluginApiSourceSetIntoPluginSourceSetIfDifferent(extension).execute((Object)project);
            Rule.wirePluginApiIntoExportedElements(extension).execute((Object)project);
        }

        private static Action<Project> wirePluginApiSourceSetIntoPluginSourceSetIfDifferent(final ExportedApiExtension extension) {
            return new Action<Project>(){

                public void execute(final Project project) {
                    extension.apis.configureEach((Action)new Action<ExportedApi>(){

                        public void execute(ExportedApi exportedApi) {
                            SourceSet implSourceSet = exportedApi.getSourceSet();
                            implSourceSet.setCompileClasspath(implSourceSet.getCompileClasspath().plus((FileCollection)project.getObjects().fileCollection().from(new Object[]{() -> {
                                SourceSet apiSourceSet = (SourceSet)exportedApi.getApiSourceSet().get();
                                if (!implSourceSet.equals(apiSourceSet)) {
                                    return apiSourceSet.getRuntimeClasspath();
                                }
                                return Collections.emptyList();
                            }})));
                            implSourceSet.setRuntimeClasspath(implSourceSet.getRuntimeClasspath().plus((FileCollection)project.getObjects().fileCollection().from(new Object[]{() -> {
                                SourceSet apiSourceSet = (SourceSet)exportedApi.getApiSourceSet().get();
                                if (!implSourceSet.equals(apiSourceSet)) {
                                    return apiSourceSet.getRuntimeClasspath();
                                }
                                return Collections.emptyList();
                            }})));
                            Provider apiSourceSet = exportedApi.getApiSourceSet().map(FilterTransformer.filter(NegateSpec.negate(implSourceSet::equals)));
                            project.getConfigurations().named(implSourceSet.getApiConfigurationName()).configure(this.extendsFrom(this.named((Provider<String>)apiSourceSet.map(SourceSet::getApiConfigurationName))));
                            project.getConfigurations().named(implSourceSet.getImplementationConfigurationName()).configure(this.extendsFrom(this.named((Provider<String>)apiSourceSet.map(SourceSet::getImplementationConfigurationName))));
                            project.getConfigurations().named(implSourceSet.getCompileOnlyConfigurationName()).configure(this.extendsFrom(this.named((Provider<String>)apiSourceSet.map(SourceSet::getCompileOnlyConfigurationName))));
                            project.getConfigurations().named(implSourceSet.getRuntimeOnlyConfigurationName()).configure(this.extendsFrom(this.named((Provider<String>)apiSourceSet.map(SourceSet::getRuntimeOnlyConfigurationName))));
                            if (project.getConfigurations().getNames().contains(this.compileOnlyApiConfigurationName(implSourceSet))) {
                                project.getConfigurations().named(this.compileOnlyApiConfigurationName(implSourceSet)).configure(this.extendsFrom(this.named((Provider<String>)apiSourceSet.map(this::compileOnlyApiConfigurationName))));
                            } else {
                                project.getConfigurations().configureEach(configuration -> {
                                    if (this.compileOnlyApiConfigurationName(implSourceSet).equals(configuration.getName())) {
                                        this.extendsFrom(this.named((Provider<String>)apiSourceSet.map(this::compileOnlyApiConfigurationName))).execute(configuration);
                                    }
                                });
                            }
                        }

                        private Provider<Configuration> named(Provider<String> configurationNameProvider) {
                            return configurationNameProvider.map(arg_0 -> ((ConfigurationContainer)project.getConfigurations()).findByName(arg_0));
                        }

                        private String compileOnlyApiConfigurationName(SourceSet sourceSet) {
                            if (sourceSet.getName().equals("main")) {
                                return "compileOnlyApi";
                            }
                            return sourceSet.getName() + "CompileOnlyApi";
                        }

                        private Action<Configuration> extendsFrom(final Provider<Configuration> configuration) {
                            return this.deferDependenciesConfiguration((BiConsumer<? super Configuration, ? super DependencySet>)new BiConsumer<Configuration, DependencySet>(){

                                @Override
                                public void accept(Configuration it, DependencySet dependencies) {
                                    dependencies.addAllLater(this.asCollectionProvider(configuration.map(t -> t.getIncoming().getDependencies())));
                                }

                                private <T> Provider<? extends Iterable<T>> asCollectionProvider(Provider<Iterable<? extends T>> provider) {
                                    provider = provider.orElse(Collections.emptyList());
                                    return project.getObjects().listProperty(Object.class).value(provider);
                                }
                            });
                        }

                        private Action<Configuration> deferDependenciesConfiguration(BiConsumer<? super Configuration, ? super DependencySet> action) {
                            return it -> it.withDependencies(dependencies -> action.accept((Configuration)it, (DependencySet)dependencies));
                        }
                    });
                }
            };
        }

        private static Action<Project> wirePluginApiIntoExportedElements(final ExportedApiExtension extension) {
            return new Action<Project>(){

                public void execute(Project project) {
                    extension.apis.configureEach(exportedApi -> {
                        SourceSet implSourceSet = exportedApi.getSourceSet();
                        Provider<Jar> jarTaskProvider = exportedApi.getJarTask().toProvider();
                        Provider classesDirectory = jarTaskProvider.flatMap(jarTask -> {
                            if (implSourceSet.getJarTaskName().equals(jarTask.getName())) {
                                return implSourceSet.getJava().getClassesDirectory();
                            }
                            String taskName = implSourceSet.getTaskName("sync", "apiClasses");
                            TaskProvider classes = null;
                            classes = project.getTasks().getNames().contains(taskName) ? project.getTasks().named(taskName, Sync.class) : project.getTasks().register(taskName, Sync.class, task -> {
                                task.setDescription(String.format("Assemble the API classes for %s.", implSourceSet));
                                task.setDestinationDir(project.file((Object)project.getLayout().getBuildDirectory().dir("tmp/" + task.getName())));
                                task.from(new Object[]{jarTask.getInputs().getSourceFiles().getElements().map(__ -> jarTask.getInputs().getSourceFiles()).map(it -> it.getAsFileTree().matching(p -> p.include(new String[]{"**/*.class"})))});
                            });
                            return project.getLayout().dir(classes.map(task -> task.getDestinationDir()));
                        });
                        Provider resourcesDirectory = exportedApi.getJarTask().toProvider().flatMap(jarTask -> {
                            if (implSourceSet.getJarTaskName().equals(jarTask.getName())) {
                                return implSourceSet.getResources().getClassesDirectory().orElse((Provider)project.getObjects().directoryProperty().fileValue(implSourceSet.getOutput().getResourcesDir()));
                            }
                            String taskName = implSourceSet.getTaskName("sync", "apiResources");
                            TaskProvider resources = null;
                            resources = project.getTasks().getNames().contains(taskName) ? project.getTasks().named(taskName, Sync.class) : project.getTasks().register(implSourceSet.getTaskName("sync", "apiResources"), Sync.class, task -> {
                                task.setDescription(String.format("Assemble the API resources for %s.", implSourceSet));
                                task.setDestinationDir(project.file((Object)project.getLayout().getBuildDirectory().dir("tmp/" + task.getName())));
                                task.from(new Object[]{jarTask.getInputs().getSourceFiles().getElements().map(__ -> jarTask.getInputs().getSourceFiles()).map(it -> it.getAsFileTree().matching(p -> p.exclude(new String[]{"**/*.class"})))});
                            });
                            return project.getLayout().dir(resources.map(task -> task.getDestinationDir()));
                        });
                        project.getConfigurations().named(implSourceSet.getApiElementsConfigurationName(), apiElements -> {
                            apiElements.outgoing(this.clearArtifacts());
                            apiElements.outgoing(this.artifacts(jarTaskProvider, (Action<? super ConfigurablePublishArtifact>)((Action)it -> {
                                it.setName(implSourceSet.getName() + "-api-jar");
                                it.setType("jar");
                                it.builtBy(new Object[]{jarTaskProvider});
                            })));
                            apiElements.getOutgoing().getVariants().named("classes", this.clearArtifacts());
                            apiElements.getOutgoing().getVariants().named("classes", this.artifacts(classesDirectory, (Action<? super ConfigurablePublishArtifact>)((Action)it -> {
                                it.setName(implSourceSet.getName() + "-api-classes");
                                it.setType("java-classes-directory");
                            })));
                        });
                        project.getConfigurations().named(implSourceSet.getRuntimeElementsConfigurationName(), runtimeElements -> {
                            runtimeElements.outgoing(this.artifacts(jarTaskProvider, (Action<? super ConfigurablePublishArtifact>)((Action)it -> {
                                it.setName(implSourceSet.getName() + "-api-jar");
                                it.setType("jar");
                                it.builtBy(new Object[]{jarTaskProvider});
                            })));
                            runtimeElements.getOutgoing().getVariants().named("classes", this.artifacts(classesDirectory, (Action<? super ConfigurablePublishArtifact>)((Action)it -> {
                                it.setName(implSourceSet.getName() + "-api-classes");
                                it.setType("java-classes-directory");
                            })));
                            runtimeElements.getOutgoing().getVariants().named("resources", this.artifacts(resourcesDirectory, (Action<? super ConfigurablePublishArtifact>)((Action)it -> {
                                it.setName(implSourceSet.getName() + "-api-resources");
                                it.setType("java-resources-directory");
                            })));
                        });
                    });
                }

                private <T> Action<T> clearArtifacts() {
                    return t -> {
                        if (t instanceof ConfigurationPublications) {
                            ((ConfigurationPublications)t).getArtifacts().clear();
                        } else if (t instanceof ConfigurationVariant) {
                            ((ConfigurationVariant)t).getArtifacts().clear();
                        } else {
                            throw new UnsupportedOperationException("Cannot get artifacts on '" + t + "'");
                        }
                    };
                }

                private <T> Action<T> artifacts(Object notation, Action<? super ConfigurablePublishArtifact> action) {
                    return t -> {
                        if (t instanceof ConfigurationPublications) {
                            ((ConfigurationPublications)t).artifact(notation, action);
                        } else if (t instanceof ConfigurationVariant) {
                            ((ConfigurationVariant)t).artifact(notation, action);
                        } else {
                            throw new UnsupportedOperationException("Cannot get artifacts on '" + t + "'");
                        }
                    };
                }
            };
        }
    }

    public static abstract class ExportedApi
    implements Named {
        private final SourceSet sourceSet;

        @Inject
        public ExportedApi(SourceSet sourceSet) {
            this.sourceSet = sourceSet;
        }

        public String getName() {
            return this.sourceSet.getName();
        }

        public SourceSet getSourceSet() {
            return this.sourceSet;
        }

        @Nested
        public abstract ConfigurableJarTaskProvider getJarTask();

        public abstract Property<SourceSet> getApiSourceSet();

        public static abstract class ConfigurableJarTaskProvider
        implements Named {
            private final TaskCollection<Task> tasks;
            private final Property<String> nameProvider;
            private final Property<Jar> taskProvider;

            @Inject
            public ConfigurableJarTaskProvider(TaskContainer tasks, ObjectFactory objects) {
                this.tasks = tasks;
                this.nameProvider = objects.property(String.class);
                this.nameProvider.finalizeValueOnRead();
                this.taskProvider = objects.property(Jar.class);
                this.taskProvider.finalizeValueOnRead();
            }

            public String getName() {
                return (String)this.nameProvider.get();
            }

            public void set(TaskProvider<? extends Jar> taskProvider) {
                this.nameProvider.set((Object)taskProvider.getName());
                this.taskProvider.set(taskProvider);
            }

            public void set(Provider<? extends Jar> taskProvider) {
                this.nameProvider.set(taskProvider.map(AbstractTask::getName));
                this.taskProvider.set(taskProvider);
            }

            public ConfigurableJarTaskProvider convention(Provider<? extends Jar> taskProvider) {
                this.nameProvider.convention(taskProvider.map(AbstractTask::getName));
                this.taskProvider.convention(taskProvider);
                return this;
            }

            public TaskProvider<Jar> getAsProvider() {
                return this.tasks.named(this.getName(), Jar.class);
            }

            public Provider<Jar> toProvider() {
                return this.taskProvider;
            }
        }
    }
}

