/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.rules;

import dev.gradleplugins.GradlePluginDevelopmentDependencies;
import dev.gradleplugins.GradlePluginDevelopmentDependencyBucket;
import dev.gradleplugins.GradlePluginDevelopmentDependencyModifiers;
import dev.gradleplugins.internal.DependencyBucketFactory;
import dev.gradleplugins.internal.DependencyFactory;
import dev.gradleplugins.internal.EnforcedPlatformDependencyModifier;
import dev.gradleplugins.internal.PlatformDependencyModifier;
import dev.gradleplugins.internal.runtime.dsl.GroovyHelper;
import dev.gradleplugins.internal.util.GradlePluginDevelopmentUtils;
import dev.gradleplugins.internal.util.LocalOrRemoteVersionTransformer;
import groovy.lang.Closure;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.groovy.runtime.MethodClosure;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;

abstract class GradlePluginDevelopmentDependenciesRule
implements Plugin<Project> {
    private static final String EXTENSION_NAME = "dependencies";

    @Inject
    public GradlePluginDevelopmentDependenciesRule() {
    }

    public void apply(final Project project) {
        project.getPluginManager().withPlugin("java-gradle-plugin", __ -> {
            DefaultGradlePluginDevelopmentDependencies dependencies = GradlePluginDevelopmentDependenciesRule.newDependenciesExtension(project);
            ((ExtensionAware)GradlePluginDevelopmentUtils.gradlePlugin(project)).getExtensions().add(EXTENSION_NAME, (Object)dependencies);
            dependencies.forEach(dependencyBucket -> GroovyHelper.instance().addNewInstanceMethod(dependencies, dependencyBucket.getName(), (Closure)new MethodClosure(dependencyBucket, "add")));
            GroovyHelper.instance().addNewInstanceMethod(dependencies, "platform", (Closure)new MethodClosure((Object)dependencies.getPlatform(), "modify"));
            GroovyHelper.instance().addNewInstanceMethod(dependencies, "enforcedPlatform", (Closure)new MethodClosure((Object)dependencies.getEnforcedPlatform(), "modify"));
            project.afterEvaluate((Action)new Action<Project>(){

                public void execute(Project ___) {
                    Configuration runtimeElements;
                    Configuration apiElements;
                    Configuration compileOnlyApi;
                    GradlePluginDevelopmentExtension extension = GradlePluginDevelopmentUtils.gradlePlugin(project);
                    SourceSet sourceSet = extension.getPluginSourceSet();
                    Configuration api = (Configuration)project.getConfigurations().findByName(sourceSet.getApiConfigurationName());
                    if (api == null) {
                        api = (Configuration)project.getConfigurations().create(sourceSet.getApiConfigurationName());
                        api.setDescription("API dependencies for " + sourceSet + ".");
                        api.setCanBeResolved(false);
                        api.setCanBeConsumed(false);
                        project.getConfigurations().getByName(sourceSet.getImplementationConfigurationName()).extendsFrom(new Configuration[]{api});
                    }
                    if ((compileOnlyApi = (Configuration)project.getConfigurations().findByName(this.compileOnlyApiConfigurationName(sourceSet))) == null) {
                        compileOnlyApi = (Configuration)project.getConfigurations().create(this.compileOnlyApiConfigurationName(sourceSet));
                        compileOnlyApi.setDescription("Compile only dependencies for " + sourceSet + ".");
                        compileOnlyApi.setCanBeResolved(false);
                        compileOnlyApi.setCanBeConsumed(false);
                        project.getConfigurations().getByName(sourceSet.getCompileOnlyConfigurationName()).extendsFrom(new Configuration[]{compileOnlyApi});
                    }
                    if ((apiElements = (Configuration)project.getConfigurations().findByName(sourceSet.getApiElementsConfigurationName())) == null) {
                        apiElements = (Configuration)project.getConfigurations().create(sourceSet.getApiElementsConfigurationName());
                        apiElements.setDescription("API elements for " + sourceSet + ".");
                        apiElements.setCanBeResolved(false);
                        apiElements.setCanBeConsumed(true);
                        apiElements.attributes(it -> {
                            it.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "java-api")));
                            it.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)project.getObjects().named(Category.class, "library")));
                            it.attribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, (Object)((Integer)project.getTasks().named(sourceSet.getCompileJavaTaskName(), JavaCompile.class).flatMap(this.toMajorVersion(project)).get()));
                            it.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)project.getObjects().named(Bundling.class, "external")));
                            it.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)project.getObjects().named(LibraryElements.class, "jar")));
                        });
                    }
                    if ((runtimeElements = (Configuration)project.getConfigurations().findByName(sourceSet.getRuntimeElementsConfigurationName())) == null) {
                        runtimeElements = (Configuration)project.getConfigurations().create(sourceSet.getRuntimeElementsConfigurationName());
                        runtimeElements.setDescription("Runtime elements for " + sourceSet + ".");
                        runtimeElements.setCanBeResolved(false);
                        runtimeElements.setCanBeConsumed(true);
                        runtimeElements.attributes(it -> {
                            it.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "java-runtime")));
                            it.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)project.getObjects().named(Category.class, "library")));
                            it.attribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, (Object)((Integer)project.getTasks().named(sourceSet.getCompileJavaTaskName(), JavaCompile.class).flatMap(this.toMajorVersion(project)).get()));
                            it.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)project.getObjects().named(Bundling.class, "external")));
                            it.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)project.getObjects().named(LibraryElements.class, "jar")));
                        });
                    }
                    apiElements.extendsFrom(new Configuration[]{api});
                    apiElements.extendsFrom(new Configuration[]{compileOnlyApi});
                    runtimeElements.extendsFrom(new Configuration[]{project.getConfigurations().getByName(extension.getPluginSourceSet().getImplementationConfigurationName())});
                    runtimeElements.extendsFrom(new Configuration[]{project.getConfigurations().getByName(extension.getPluginSourceSet().getRuntimeOnlyConfigurationName())});
                }

                private String compileOnlyApiConfigurationName(SourceSet sourceSet) {
                    if (sourceSet.getName().equals("main")) {
                        return "compileOnlyApi";
                    }
                    return sourceSet.getName() + "CompileOnlyApi";
                }

                private Transformer<Provider<Integer>, JavaCompile> toMajorVersion(final Project project2) {
                    return new Transformer<Provider<Integer>, JavaCompile>(){

                        public Provider<Integer> transform(JavaCompile task) {
                            return this.getReleaseOption(project2, task.getOptions()).orElse(this.getReleaseFlag(project2, task.getOptions().getCompilerArgs())).orElse(project2.provider(() -> Integer.parseInt(JavaVersion.toVersion((Object)task.getTargetCompatibility()).getMajorVersion())));
                        }

                        private Provider<Integer> getReleaseOption(Project project, CompileOptions options) {
                            try {
                                Method getRelease = options.getClass().getDeclaredMethod("getRelease", new Class[0]);
                                Provider result = (Provider)getRelease.invoke((Object)options, new Object[0]);
                                return result;
                            }
                            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                                return project.provider(() -> null);
                            }
                        }

                        private Provider<Integer> getReleaseFlag(Project project, List<String> compilerArgs) {
                            return project.provider(() -> {
                                int flagIndex = compilerArgs.indexOf("--release");
                                if (flagIndex != -1 && flagIndex + 1 < compilerArgs.size()) {
                                    return Integer.parseInt(String.valueOf(compilerArgs.get(flagIndex + 1)));
                                }
                                return null;
                            });
                        }
                    };
                }
            });
        });
    }

    private static DefaultGradlePluginDevelopmentDependencies newDependenciesExtension(Project project) {
        return (DefaultGradlePluginDevelopmentDependencies)project.getObjects().newInstance(DefaultGradlePluginDevelopmentDependencies.class, new Object[]{project, new DependencyBucketFactory(project, (Provider<SourceSet>)project.provider(() -> GradlePluginDevelopmentUtils.gradlePlugin(project).getPluginSourceSet()))});
    }

    static abstract class DefaultGradlePluginDevelopmentDependencies
    implements GradlePluginDevelopmentDependencies,
    Iterable<GradlePluginDevelopmentDependencyBucket> {
        private final Transformer<Dependency, String> localOrRemoteGradleApi;
        private final Map<String, GradlePluginDevelopmentDependencyBucket> dependencyBuckets = new LinkedHashMap<String, GradlePluginDevelopmentDependencyBucket>();
        private final DependencyFactory dependencyFactory;
        private final GradlePluginDevelopmentDependencyModifiers.DependencyModifier platformDependencyModifier;
        private final GradlePluginDevelopmentDependencyModifiers.DependencyModifier enforcedPlatformDependencyModifier;
        private final Project project;

        @Inject
        public DefaultGradlePluginDevelopmentDependencies(Project project, DependencyBucketFactory dependencyBucketFactory) {
            this.dependencyFactory = DependencyFactory.forProject(project);
            this.localOrRemoteGradleApi = new LocalOrRemoteVersionTransformer<Dependency>(this.dependencyFactory::localGradleApi, this.dependencyFactory::gradleApi);
            this.platformDependencyModifier = new PlatformDependencyModifier(project);
            this.enforcedPlatformDependencyModifier = new EnforcedPlatformDependencyModifier(project);
            this.project = project;
            this.add(dependencyBucketFactory.create("api"));
            this.add(dependencyBucketFactory.create("implementation"));
            this.add(dependencyBucketFactory.create("compileOnlyApi"));
            this.add(dependencyBucketFactory.create("compileOnly"));
            this.add(dependencyBucketFactory.create("runtimeOnly"));
            this.add(dependencyBucketFactory.create("annotationProcessor"));
        }

        private void add(GradlePluginDevelopmentDependencyBucket dependencyBucket) {
            this.dependencyBuckets.put(dependencyBucket.getName(), dependencyBucket);
        }

        @Override
        public GradlePluginDevelopmentDependencyBucket getApi() {
            return this.dependencyBuckets.get("api");
        }

        @Override
        public GradlePluginDevelopmentDependencyBucket getImplementation() {
            return this.dependencyBuckets.get("implementation");
        }

        @Override
        public GradlePluginDevelopmentDependencyBucket getCompileOnlyApi() {
            return this.dependencyBuckets.get("compileOnlyApi");
        }

        @Override
        public GradlePluginDevelopmentDependencyBucket getCompileOnly() {
            return this.dependencyBuckets.get("compileOnly");
        }

        @Override
        public GradlePluginDevelopmentDependencyBucket getRuntimeOnly() {
            return this.dependencyBuckets.get("runtimeOnly");
        }

        @Override
        public GradlePluginDevelopmentDependencyBucket getAnnotationProcessor() {
            return this.dependencyBuckets.get("annotationProcessor");
        }

        @Override
        public GradlePluginDevelopmentDependencyModifiers.DependencyModifier getPlatform() {
            return this.platformDependencyModifier;
        }

        @Override
        public GradlePluginDevelopmentDependencyModifiers.DependencyModifier getEnforcedPlatform() {
            return this.enforcedPlatformDependencyModifier;
        }

        @Override
        public Dependency gradleApi(String version) {
            return (Dependency)this.localOrRemoteGradleApi.transform((Object)version);
        }

        @Override
        public ProjectDependency project(String projectPath) {
            return this.dependencyFactory.create(this.project.project(projectPath));
        }

        @Override
        public ProjectDependency project() {
            return this.dependencyFactory.create(this.project);
        }

        @Override
        public ExternalModuleDependency gradlePlugin(String pluginNotation) {
            return this.dependencyFactory.gradlePlugin(pluginNotation);
        }

        @Override
        public Iterator<GradlePluginDevelopmentDependencyBucket> iterator() {
            return this.dependencyBuckets.values().iterator();
        }
    }
}

