/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.util;

import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.Transformer;

public final class LocalOrRemoteVersionTransformer<T>
implements Transformer<T, String> {
    private static final String LOCAL_GRADLE_VERSION = "local";
    private final Supplier<T> localSupplier;
    private final Function<String, T> remoteMapper;

    public LocalOrRemoteVersionTransformer(Supplier<T> localSupplier, Function<String, T> remoteMapper) {
        this.localSupplier = localSupplier;
        this.remoteMapper = remoteMapper;
    }

    public T transform(String version) {
        if (LOCAL_GRADLE_VERSION.equals(version)) {
            return this.localSupplier.get();
        }
        return this.remoteMapper.apply(version);
    }
}

