/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import dev.gradleplugins.runnerkit.BuildResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BuildFailure
implements BuildResult.Failure {
    private final String description;
    private final List<String> causes;

    BuildFailure(String description, List<String> causes) {
        this.description = description;
        this.causes = causes;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getCauses() {
        return this.causes;
    }

    public static BuildFailure describedBy(String description) {
        return new BuildFailure(description, Collections.emptyList());
    }

    public BuildFailure causedBy(String cause) {
        ArrayList<String> causes = new ArrayList<String>();
        causes.addAll(this.causes);
        causes.add(cause);
        return new BuildFailure(this.description, Collections.unmodifiableList(causes));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildFailure)) {
            return false;
        }
        BuildFailure other = (BuildFailure)o;
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$causes = this.getCauses();
        List<String> other$causes = other.getCauses();
        return !(this$causes == null ? other$causes != null : !((Object)this$causes).equals(other$causes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $causes = this.getCauses();
        result = result * 59 + ($causes == null ? 43 : ((Object)$causes).hashCode());
        return result;
    }
}

