/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.providers;

import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.providers.AbstractGradleExecutionProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionCommandLineProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class BuildCacheProvider
extends AbstractGradleExecutionProvider<GradleExecutionContext.BuildCache>
implements GradleExecutionCommandLineProvider {
    public static BuildCacheProvider enabled() {
        return BuildCacheProvider.fixed(BuildCacheProvider.class, GradleExecutionContext.BuildCache.ENABLED);
    }

    public static BuildCacheProvider disabled() {
        return BuildCacheProvider.fixed(BuildCacheProvider.class, GradleExecutionContext.BuildCache.DISABLED);
    }

    @Override
    public List<String> getAsArguments() {
        if (((GradleExecutionContext.BuildCache)this.get()).equals((Object)GradleExecutionContext.BuildCache.ENABLED)) {
            return Arrays.asList("--build-cache");
        }
        return Collections.emptyList();
    }

    @Override
    public void validate(GradleExecutionContext context) {
        if (((GradleExecutionContext.BuildCache)this.get()).equals((Object)GradleExecutionContext.BuildCache.ENABLED)) {
            if (((List)context.getArguments().get()).contains("--build-cache")) {
                throw new InvalidRunnerConfigurationException("Please remove command line flag enabling build cache as it was already enabled via GradleRunner#withBuildCacheEnabled().");
            }
            if (((List)context.getArguments().get()).contains("--no-build-cache")) {
                throw new InvalidRunnerConfigurationException("Please remove command line flag disabling build cache and any call to GradleRunner#withBuildCacheEnabled() for this runner as it is disabled by default for all toolbox runner.");
            }
        } else if (((GradleExecutionContext.BuildCache)this.get()).equals((Object)GradleExecutionContext.BuildCache.DISABLED)) {
            if (((List)context.getArguments().get()).contains("--build-cache")) {
                throw new InvalidRunnerConfigurationException("Please use GradleRunner#withBuildCacheEnabled() instead of using flag in command line arguments.");
            }
            if (((List)context.getArguments().get()).contains("--no-build-cache")) {
                throw new InvalidRunnerConfigurationException("Please remove command line flag disabling build cache as it is disabled by default for all toolbox runner.");
            }
        }
    }
}

