/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.core.exec;

import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.CommandLineToolExecutionHandle;
import dev.nokee.core.exec.CommandLineToolInvocation;
import dev.nokee.core.exec.CommandLineToolInvocationEnvironmentVariables;
import dev.nokee.core.exec.CommandLineToolInvocationErrorOutputRedirect;
import dev.nokee.core.exec.CommandLineToolInvocationStandardOutputRedirect;
import dev.nokee.core.exec.ExecException;
import dev.nokee.core.exec.internal.CommandLineToolInvocationOutputRedirectInternal;
import dev.nokee.core.exec.internal.CommandLineToolOutputStreams;
import dev.nokee.core.exec.internal.CommandLineToolOutputStreamsImpl;
import java.io.ByteArrayOutputStream;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.process.ExecOperations;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

public abstract class GradleWorkerExecutorEngine
implements CommandLineToolExecutionEngine<Handle> {
    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @Override
    public Handle submit(CommandLineToolInvocation invocation) {
        WorkQueue workQueue = this.getWorkerExecutor().noIsolation();
        workQueue.submit(GradleWorkerExecutorEngineWorkAction.class, it -> {
            it.getCommandLine().add((Object)invocation.getTool().getExecutable());
            it.getCommandLine().addAll(invocation.getArguments().get());
            it.getStandardOutputRedirect().set((Object)invocation.getStandardOutputRedirect());
            it.getErrorOutputRedirect().set((Object)invocation.getErrorOutputRedirect());
            it.getEnvironmentVariables().set((Object)invocation.getEnvironmentVariables());
        });
        return new Handle(workQueue);
    }

    public static abstract class GradleWorkerExecutorEngineWorkAction
    implements WorkAction<GradleWorkerExecutorEngineWorkParameters> {
        @Inject
        protected abstract ExecOperations getExecOperations();

        public void execute() {
            ByteArrayOutputStream logs = new ByteArrayOutputStream();
            try {
                this.getExecOperations().exec(spec -> {
                    spec.commandLine((Iterable)((GradleWorkerExecutorEngineWorkParameters)this.getParameters()).getCommandLine().get());
                    CommandLineToolOutputStreams streams = new CommandLineToolOutputStreamsImpl(logs, logs);
                    if (((GradleWorkerExecutorEngineWorkParameters)this.getParameters()).getStandardOutputRedirect().get() instanceof CommandLineToolInvocationOutputRedirectInternal) {
                        streams = ((CommandLineToolInvocationOutputRedirectInternal)((GradleWorkerExecutorEngineWorkParameters)this.getParameters()).getStandardOutputRedirect().get()).redirect(streams);
                    }
                    if (((GradleWorkerExecutorEngineWorkParameters)this.getParameters()).getErrorOutputRedirect().get() instanceof CommandLineToolInvocationOutputRedirectInternal) {
                        streams = ((CommandLineToolInvocationOutputRedirectInternal)((GradleWorkerExecutorEngineWorkParameters)this.getParameters()).getErrorOutputRedirect().get()).redirect(streams);
                    }
                    spec.setStandardOutput(streams.getStandardOutput());
                    spec.setErrorOutput(streams.getErrorOutput());
                    spec.setEnvironment(((CommandLineToolInvocationEnvironmentVariables)((GradleWorkerExecutorEngineWorkParameters)this.getParameters()).getEnvironmentVariables().get()).getAsMap());
                });
            }
            catch (GradleException e) {
                throw new ExecException("An error happen while executing command, here is the output:\n" + logs.toString());
            }
        }
    }

    public static interface GradleWorkerExecutorEngineWorkParameters
    extends WorkParameters {
        public ListProperty<String> getCommandLine();

        public Property<CommandLineToolInvocationStandardOutputRedirect> getStandardOutputRedirect();

        public Property<CommandLineToolInvocationErrorOutputRedirect> getErrorOutputRedirect();

        public Property<CommandLineToolInvocationEnvironmentVariables> getEnvironmentVariables();
    }

    public static class Handle
    implements CommandLineToolExecutionHandle {
        private final WorkQueue workQueue;

        public void await() {
            this.workQueue.await();
        }

        public Handle(WorkQueue workQueue) {
            this.workQueue = workQueue;
        }
    }
}

