/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import dev.gradleplugins.runnerkit.BuildFailure;
import dev.gradleplugins.runnerkit.BuildResult;
import dev.nokee.core.exec.CommandLineToolLogContent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.util.TextUtil;

public final class BuildFailures {
    private static final Pattern FAILURE_PATTERN = Pattern.compile("FAILURE: (.+)");
    private static final Pattern CAUSE_PATTERN = Pattern.compile("(?m)(^\\s*> )");
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("(?ms)^\\* What went wrong:$(.+?)^\\* Try:$");
    private static final Pattern LOCATION_PATTERN = Pattern.compile("(?ms)^\\* Where:((.+?)'.+?') line: (\\d+)$");
    private static final Pattern RESOLUTION_PATTERN = Pattern.compile("(?ms)^\\* Try:$(.+?)^\\* Exception is:$");
    private final String summary;
    private final List<BuildResult.Failure> problems;

    public BuildFailures(String summary, List<String> lineNumbers, List<String> fileNames, List<BuildResult.Failure> problems, String resolution) {
        this.summary = summary;
        this.problems = problems;
    }

    public List<BuildResult.Failure> get() {
        return this.problems;
    }

    public String getSummary() {
        return this.summary;
    }

    private boolean hasFailure() {
        return !this.problems.isEmpty();
    }

    private boolean hasMultipleFailures() {
        return this.problems.size() > 1;
    }

    private void writeHeaderIfMultipleFailure(StringBuilder builder, int count) {
        if (this.hasMultipleFailures()) {
            builder.append(count).append(": Task failed with an exception.").append("\n");
            builder.append("-----------").append("\n");
        }
    }

    private void writeFooterIfMultipleFailure(StringBuilder builder, int count) {
        if (this.hasMultipleFailures()) {
            builder.append("\n").append("==============================================================================");
            if (count < this.problems.size()) {
                builder.append("\n").append("\n");
            }
        }
    }

    void toString(StringBuilder result) {
        if (this.hasFailure()) {
            result.append("FAILURE: ").append(this.summary).append("\n");
            result.append("\n");
            for (int i = 0; i < this.problems.size(); ++i) {
                BuildResult.Failure failure = this.problems.get(i);
                this.writeHeaderIfMultipleFailure(result, i + 1);
                result.append("* What went wrong:").append("\n");
                result.append(failure.getDescription());
                String indent = "\n> ";
                for (String cause : failure.getCauses()) {
                    result.append(indent).append(cause);
                    indent = "  " + indent;
                }
                this.writeFooterIfMultipleFailure(result, i + 1);
            }
        }
    }

    public static BuildFailures from(final CommandLineToolLogContent output) {
        CommandLineToolLogContent failureContent = output.visitEachLine(new Consumer<CommandLineToolLogContent.LineDetails>(){
            private boolean found = false;

            @Override
            public void accept(CommandLineToolLogContent.LineDetails it) {
                boolean failureMatching = FAILURE_PATTERN.matcher(it.getLine()).matches();
                if (this.found && failureMatching) {
                    throw new IllegalArgumentException("Found multiple failure sections in log output: " + output.getAsString());
                }
                if (!this.found && failureMatching) {
                    this.found = true;
                } else if (!this.found) {
                    it.dropLine();
                }
            }
        });
        Builder builder = BuildFailures.builder();
        String failureText = failureContent.getAsString();
        Matcher matcher = FAILURE_PATTERN.matcher(failureText);
        if (matcher.lookingAt()) {
            builder.withSummary(matcher.group(1));
        }
        matcher = LOCATION_PATTERN.matcher(failureText);
        while (matcher.find()) {
            builder.addFileName(matcher.group(1).trim());
            builder.addLineNumber(matcher.group(3));
        }
        matcher = DESCRIPTION_PATTERN.matcher(failureText);
        while (matcher.find()) {
            String problemStr = matcher.group(1);
            BuildFailure problem = BuildFailures.extract(problemStr);
            builder.withFailure((BuildResult.Failure)problem);
        }
        matcher = RESOLUTION_PATTERN.matcher(failureText);
        if (matcher.find()) {
            builder.withResolution(matcher.group(1).trim());
        }
        return builder.build();
    }

    private static BuildFailure extract(String problem) {
        String description;
        Matcher matcher = CAUSE_PATTERN.matcher(problem);
        ArrayList<String> causes = new ArrayList<String>();
        if (!matcher.find()) {
            description = TextUtil.normaliseLineSeparators((String)problem.trim());
        } else {
            String cause;
            String prefixPattern;
            int pos;
            description = TextUtil.normaliseLineSeparators((String)problem.substring(0, matcher.start()).trim());
            while (true) {
                pos = matcher.end();
                int prefix = matcher.group(1).length();
                prefixPattern = BuildFailures.toPrefixPattern(prefix);
                if (!matcher.find(pos)) break;
                cause = TextUtil.normaliseLineSeparators((String)problem.substring(pos, matcher.start()).trim().replaceAll(prefixPattern, ""));
                causes.add(cause);
            }
            cause = TextUtil.normaliseLineSeparators((String)problem.substring(pos).trim().replaceAll(prefixPattern, ""));
            causes.add(cause);
        }
        return new BuildFailure(description, causes);
    }

    private static String toPrefixPattern(int prefix) {
        StringBuilder builder = new StringBuilder("(?m)^");
        for (int i = 0; i < prefix; ++i) {
            builder.append(' ');
        }
        return builder.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "BuildFailures(summary=" + this.getSummary() + ", problems=" + this.problems + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildFailures)) {
            return false;
        }
        BuildFailures other = (BuildFailures)o;
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        List<BuildResult.Failure> this$problems = this.problems;
        List<BuildResult.Failure> other$problems = other.problems;
        return !(this$problems == null ? other$problems != null : !((Object)this$problems).equals(other$problems));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        List<BuildResult.Failure> $problems = this.problems;
        result = result * 59 + ($problems == null ? 43 : ((Object)$problems).hashCode());
        return result;
    }

    public static final class Builder {
        private String resolution;
        private final List<BuildResult.Failure> problems = new ArrayList<BuildResult.Failure>();
        private final List<String> lineNumbers = new ArrayList<String>();
        private final List<String> fileNames = new ArrayList<String>();
        private String summary;

        public Builder withResolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public Builder withFailure(BuildResult.Failure problem) {
            this.problems.add(problem);
            return this;
        }

        public Builder addLineNumber(String lineNumber) {
            this.lineNumbers.add(lineNumber);
            return this;
        }

        public Builder addFileName(String fileName) {
            this.fileNames.add(fileName);
            return this;
        }

        public Builder withSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public BuildFailures build() {
            return new BuildFailures(this.summary, this.lineNumbers, this.fileNames, this.problems, this.resolution);
        }
    }
}

