/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.providers;

import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.providers.GradleExecutionProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionProviderInternal;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

abstract class AbstractGradleExecutionProvider<T>
implements GradleExecutionProviderInternal<T> {
    private static final ThreadLocal<GradleExecutionProvider<?>> NEXT_PARAMETER = new ThreadLocal();
    private final GradleExecutionProvider<T> value = NEXT_PARAMETER.get();

    protected AbstractGradleExecutionProvider() {
        NEXT_PARAMETER.remove();
    }

    public T get() {
        return (T)this.value.get();
    }

    public T orElse(T other) {
        return (T)this.value.orElse(other);
    }

    public T orElseGet(Supplier<T> supplier) {
        return (T)this.value.orElseGet(supplier);
    }

    public boolean isPresent() {
        return this.value.isPresent();
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        return this.value.map(mapper);
    }

    @Override
    public void calculateValue(GradleExecutionContext context) {
        if (this.value instanceof CalculatedValueProvider) {
            ((CalculatedValueProvider)this.value).calculateValue(context);
        }
    }

    protected static <T extends GradleExecutionProvider<?>> T noValue(Class<T> type) {
        NEXT_PARAMETER.set(new NoValueProvider<T>(type));
        try {
            return (T)((GradleExecutionProvider)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends GradleExecutionProvider<S>, S> T fixed(Class<T> type, S value) {
        NEXT_PARAMETER.set(new FixedValueProvider<S>(value));
        try {
            return (T)((GradleExecutionProvider)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends GradleExecutionProvider<S>, S> T supplied(Class<T> type, Supplier<S> value) {
        NEXT_PARAMETER.set(new SuppliedValueProvider<S>(value));
        try {
            return (T)((GradleExecutionProvider)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends GradleExecutionProvider<S>, S> T calculated(Class<T> type, Function<GradleExecutionContext, S> value) {
        NEXT_PARAMETER.set(new CalculatedValueProvider<S>(value));
        try {
            return (T)((GradleExecutionProvider)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "AbstractGradleExecutionProvider(value=" + this.value + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractGradleExecutionProvider)) {
            return false;
        }
        AbstractGradleExecutionProvider other = (AbstractGradleExecutionProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GradleExecutionProvider<T> this$value = this.value;
        GradleExecutionProvider<T> other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractGradleExecutionProvider;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GradleExecutionProvider<T> $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    private static class CalculatedValueProvider<T>
    implements GradleExecutionProvider<T> {
        private final Function<GradleExecutionContext, T> generator;
        private T value;

        CalculatedValueProvider(Function<GradleExecutionContext, T> generator) {
            this.generator = generator;
        }

        public T get() {
            this.assertValueCalculated();
            return this.value;
        }

        public T orElse(T other) {
            this.assertValueCalculated();
            return this.value;
        }

        public T orElseGet(Supplier<T> supplier) {
            this.assertValueCalculated();
            return this.value;
        }

        public boolean isPresent() {
            return true;
        }

        public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
            this.assertValueCalculated();
            return Optional.of(this.value).map(mapper);
        }

        private void assertValueCalculated() {
            if (this.value == null) {
                throw new RuntimeException("value not calculated");
            }
        }

        public void calculateValue(GradleExecutionContext context) {
            this.value = this.generator.apply(context);
        }

        public String toString() {
            return "calculated(" + this.value + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CalculatedValueProvider)) {
                return false;
            }
            CalculatedValueProvider other = (CalculatedValueProvider)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Function<GradleExecutionContext, T> this$generator = this.generator;
            Function<GradleExecutionContext, T> other$generator = other.generator;
            if (this$generator == null ? other$generator != null : !this$generator.equals(other$generator)) {
                return false;
            }
            T this$value = this.value;
            T other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CalculatedValueProvider;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Function<GradleExecutionContext, T> $generator = this.generator;
            result = result * 59 + ($generator == null ? 43 : $generator.hashCode());
            T $value = this.value;
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }

    private static class SuppliedValueProvider<T>
    implements GradleExecutionProvider<T> {
        private final Supplier<T> value;

        SuppliedValueProvider(Supplier<T> value) {
            this.value = value;
        }

        public T get() {
            return this.value.get();
        }

        public T orElse(T other) {
            return this.value.get();
        }

        public T orElseGet(Supplier<T> supplier) {
            return this.value.get();
        }

        public boolean isPresent() {
            return true;
        }

        public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
            return Optional.of(this.value.get()).map(mapper);
        }

        public String toString() {
            return "supplied(" + this.value + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SuppliedValueProvider)) {
                return false;
            }
            SuppliedValueProvider other = (SuppliedValueProvider)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Supplier<T> this$value = this.value;
            Supplier<T> other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SuppliedValueProvider;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Supplier<T> $value = this.value;
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }

    private static class FixedValueProvider<T>
    implements GradleExecutionProvider<T> {
        private final T value;

        FixedValueProvider(T value) {
            this.value = value;
        }

        public T get() {
            return this.value;
        }

        public T orElse(T other) {
            return this.value;
        }

        public T orElseGet(Supplier<T> supplier) {
            return this.value;
        }

        public boolean isPresent() {
            return true;
        }

        public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
            return Optional.of(this.value).map(mapper);
        }

        public String toString() {
            return "fixed(" + this.value + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FixedValueProvider)) {
                return false;
            }
            FixedValueProvider other = (FixedValueProvider)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$value = this.value;
            T other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FixedValueProvider;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $value = this.value;
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }

    private static final class NoValueProvider<T>
    implements GradleExecutionProvider<T> {
        private final Class<T> type;

        public NoValueProvider(Class<T> type) {
            this.type = type;
        }

        public T get() {
            throw new UnsupportedOperationException(String.format("Cannot get value for '%s'.", this.type.getSimpleName()));
        }

        public T orElse(T other) {
            return other;
        }

        public T orElseGet(Supplier<T> supplier) {
            return supplier.get();
        }

        public boolean isPresent() {
            return false;
        }

        public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
            return Optional.empty();
        }

        public String toString() {
            return "no value";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof NoValueProvider;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }
}

