/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee;

import dev.nokee.utils.ActionUtils;
import java.util.Objects;
import org.gradle.api.Action;

public interface ChainingAction<T>
extends Action<T> {
    default public ChainingAction<T> andThen(Action<? super T> after) {
        Objects.requireNonNull(after);
        if (ActionUtils.doesSomething(after)) {
            return t -> {
                this.execute(t);
                after.execute(t);
            };
        }
        return this;
    }

    public static <T> ChainingAction<T> of(Action<T> action) {
        if (ActionUtils.doesSomething(action)) {
            return arg_0 -> action.execute(arg_0);
        }
        return ChainingAction.doNothing();
    }

    public static <T> ChainingAction<T> doNothing() {
        return ActionUtils.DoNothingAction.INSTANCE;
    }
}

