/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.providers;

import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.providers.AbstractGradleExecutionProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionCommandLineProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class BuildScanProvider
extends AbstractGradleExecutionProvider<GradleExecutionContext.BuildScan>
implements GradleExecutionCommandLineProvider {
    private File initScriptFile;

    public static BuildScanProvider disabled() {
        return BuildScanProvider.fixed(BuildScanProvider.class, GradleExecutionContext.BuildScan.DISABLED);
    }

    public static BuildScanProvider enabled() {
        return BuildScanProvider.fixed(BuildScanProvider.class, GradleExecutionContext.BuildScan.ENABLED);
    }

    private List<String> getPublishBuildScanArguments() {
        if (this.initScriptFile == null) {
            try {
                this.initScriptFile = File.createTempFile("build-scan.", ".init.gradle");
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        try (PrintWriter out = new PrintWriter(new FileOutputStream(this.initScriptFile));){
            out.println("import org.gradle.util.GradleVersion");
            out.println("");
            out.println("def isTopLevelBuild = gradle.getParent() == null");
            out.println("");
            out.println("if (isTopLevelBuild) {");
            out.println("    def gradleVersion = GradleVersion.current().baseVersion");
            out.println("    def atLeastGradle5 = gradleVersion >= GradleVersion.version('5.0')");
            out.println("    def atLeastGradle6 = gradleVersion >= GradleVersion.version('6.0')");
            out.println("");
            out.println("    if (atLeastGradle6) {");
            out.println("        settingsEvaluated {");
            out.println("            if (it.pluginManager.hasPlugin('com.gradle.enterprise')) {");
            out.println("               configureExtension(it.extensions['gradleEnterprise'].buildScan)");
            out.println("            }");
            out.println("        }");
            out.println("    } else if (atLeastGradle5) {");
            out.println("        rootProject {");
            out.println("            if (it.pluginManager.hasPlugin('com.gradle.build-scan')) {");
            out.println("               configureExtension(extensions['buildScan'])");
            out.println("            }");
            out.println("        }");
            out.println("    }");
            out.println("}");
            out.println("");
            out.println("void configureExtension(extension) {");
            out.println("    extension.with {");
            out.println("        termsOfServiceUrl = 'https://gradle.com/terms-of-service'");
            out.println("        termsOfServiceAgree = 'yes'");
            out.println("    }");
            out.println("}");
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
        return Arrays.asList("--init-script", this.initScriptFile.getAbsolutePath(), "--scan");
    }

    @Override
    public List<String> getAsArguments() {
        if (((GradleExecutionContext.BuildScan)this.get()).equals((Object)GradleExecutionContext.BuildScan.ENABLED)) {
            return this.getPublishBuildScanArguments();
        }
        return Collections.emptyList();
    }

    @Override
    public void validate(GradleExecutionContext context) {
        if (((GradleExecutionContext.BuildScan)this.get()).equals((Object)GradleExecutionContext.BuildScan.ENABLED)) {
            if (((List)context.getArguments().get()).contains("--scan")) {
                throw new InvalidRunnerConfigurationException("Please remove command line flag enabling build scan as it was already enabled via GradleRunner#publishBuildScans().");
            }
            if (((List)context.getArguments().get()).contains("--no-scan")) {
                throw new InvalidRunnerConfigurationException("Please remove command line flag disabling build scan and any call to GradleRunner#publishBuildScans() for this runner as it is disabled by default for all toolbox runner.");
            }
        } else if (((GradleExecutionContext.BuildScan)this.get()).equals((Object)GradleExecutionContext.BuildScan.DISABLED)) {
            if (((List)context.getArguments().get()).contains("--scan")) {
                throw new InvalidRunnerConfigurationException("Please use GradleRunner#publishBuildScans() instead of using flag in command line arguments.");
            }
            if (((List)context.getArguments().get()).contains("--no-scan")) {
                throw new InvalidRunnerConfigurationException("Please remove command line flag disabling build scan as it is disabled by default for all toolbox runner.");
            }
        }
    }
}

