/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.providers;

import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.providers.AbstractGradleExecutionProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionJvmSystemPropertyProvider;
import dev.gradleplugins.runnerkit.providers.GradleUserHomeDirectoryProvider;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class DaemonBaseDirectoryProvider
extends AbstractGradleExecutionProvider<File>
implements GradleExecutionJvmSystemPropertyProvider {
    static final String TEST_KIT_DAEMON_DIR_NAME = "test-kit-daemon";
    static final String DAEMON_BUILD_OPTIONS_BASE_DIR_GRADLE_PROPERTY = "org.gradle.daemon.registry.base";

    public static DaemonBaseDirectoryProvider of(File daemonBaseDirectory) {
        return DaemonBaseDirectoryProvider.fixed(DaemonBaseDirectoryProvider.class, daemonBaseDirectory);
    }

    public static DaemonBaseDirectoryProvider of(Function<GradleExecutionContext, File> daemonBaseDirectorySupplier) {
        return DaemonBaseDirectoryProvider.calculated(DaemonBaseDirectoryProvider.class, daemonBaseDirectorySupplier);
    }

    public static DaemonBaseDirectoryProvider testKitDaemonDirectory() {
        return DaemonBaseDirectoryProvider.calculated(DaemonBaseDirectoryProvider.class, GradleUserHomeDirectoryProvider.relativeToGradleUserHome(TEST_KIT_DAEMON_DIR_NAME));
    }

    @Override
    public Map<String, String> getAsJvmSystemProperties() {
        return this.map(DaemonBaseDirectoryProvider::asJvmSystemProperties).orElseGet(Collections::emptyMap);
    }

    private static Map<String, String> asJvmSystemProperties(File daemonBaseDirectory) {
        return Collections.singletonMap(DAEMON_BUILD_OPTIONS_BASE_DIR_GRADLE_PROPERTY, daemonBaseDirectory.getAbsolutePath());
    }

    @Override
    public void validate(GradleExecutionContext context) {
        if (((List)context.getArguments().get()).stream().anyMatch(it -> it.startsWith("-Dorg.gradle.daemon.registry.base"))) {
            throw new InvalidRunnerConfigurationException("Please use GradleRunner#withDaemonBaseDirectory(File) instead of using the command line flags.");
        }
    }
}

