/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.core.exec;

import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.CommandLineToolExecutionHandle;
import dev.nokee.core.exec.CommandLineToolExecutionResult;
import dev.nokee.core.exec.CommandLineToolInvocation;
import dev.nokee.core.exec.CommandLineToolLogContent;
import dev.nokee.core.exec.internal.CommandLineToolInvocationOutputRedirectInternal;
import dev.nokee.core.exec.internal.CommandLineToolOutputStreams;
import dev.nokee.core.exec.internal.CommandLineToolOutputStreamsIntertwineImpl;
import dev.nokee.core.exec.internal.DefaultCommandLineToolExecutionResult;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.exec.PumpStreamHandler;

public class ProcessBuilderEngine
implements CommandLineToolExecutionEngine<Handle> {
    @Override
    public Handle submit(CommandLineToolInvocation invocation) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command().add(invocation.getTool().getExecutable());
        processBuilder.command().addAll(invocation.getArguments().get());
        invocation.getWorkingDirectory().ifPresent(processBuilder::directory);
        processBuilder.environment().putAll(invocation.getEnvironmentVariables().getAsMap());
        try {
            Process process = processBuilder.start();
            CommandLineToolOutputStreamsIntertwineImpl endStreams = new CommandLineToolOutputStreamsIntertwineImpl();
            CommandLineToolOutputStreams streams = endStreams;
            if (invocation.getStandardOutputRedirect() instanceof CommandLineToolInvocationOutputRedirectInternal) {
                streams = ((CommandLineToolInvocationOutputRedirectInternal)((Object)invocation.getStandardOutputRedirect())).redirect(streams);
            }
            if (invocation.getErrorOutputRedirect() instanceof CommandLineToolInvocationOutputRedirectInternal) {
                streams = ((CommandLineToolInvocationOutputRedirectInternal)((Object)invocation.getErrorOutputRedirect())).redirect(streams);
            }
            PumpStreamHandler streamHandler = new PumpStreamHandler(streams.getStandardOutput(), streams.getErrorOutput());
            streamHandler.setProcessOutputStream(process.getInputStream());
            streamHandler.setProcessErrorStream(process.getErrorStream());
            streamHandler.start();
            return new Handle(process, streamHandler, endStreams::getStandardOutputContent, endStreams::getErrorOutputContent, endStreams::getOutputContent, () -> String.join((CharSequence)" ", processBuilder.command()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class Handle
    implements CommandLineToolExecutionHandle {
        private final Process process;
        private final PumpStreamHandler streamHandler;
        private final Supplier<CommandLineToolLogContent> standardOutput;
        private final Supplier<CommandLineToolLogContent> errorOutput;
        private final Supplier<CommandLineToolLogContent> output;
        private final Supplier<String> displayName;

        public CommandLineToolExecutionResult waitFor() {
            try {
                this.process.waitFor();
                this.streamHandler.stop();
                return new DefaultCommandLineToolExecutionResult(this.process.exitValue(), this.standardOutput.get(), this.errorOutput.get(), this.output.get(), this.displayName);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public CommandLineToolExecutionResult waitFor(long timeout, TimeUnit unit) {
            try {
                this.process.waitFor(timeout, unit);
                this.streamHandler.stop();
                return new DefaultCommandLineToolExecutionResult(this.process.exitValue(), this.standardOutput.get(), this.errorOutput.get(), this.output.get(), this.displayName);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public CommandLineToolExecutionResult waitFor(Duration duration) {
            try {
                this.process.waitFor(duration.toMillis(), TimeUnit.MILLISECONDS);
                this.streamHandler.stop();
                return new DefaultCommandLineToolExecutionResult(this.process.exitValue(), this.standardOutput.get(), this.errorOutput.get(), this.output.get(), this.displayName);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public Handle(Process process, PumpStreamHandler streamHandler, Supplier<CommandLineToolLogContent> standardOutput, Supplier<CommandLineToolLogContent> errorOutput, Supplier<CommandLineToolLogContent> output, Supplier<String> displayName) {
            this.process = process;
            this.streamHandler = streamHandler;
            this.standardOutput = standardOutput;
            this.errorOutput = errorOutput;
            this.output = output;
            this.displayName = displayName;
        }
    }
}

