/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.core.exec.internal;

import dev.nokee.core.exec.CommandLineToolExecutionResult;
import dev.nokee.core.exec.CommandLineToolLogContent;
import dev.nokee.core.exec.ExecException;
import java.util.function.Supplier;

public class DefaultCommandLineToolExecutionResult
implements CommandLineToolExecutionResult {
    private final int exitValue;
    private final CommandLineToolLogContent output;
    private final CommandLineToolLogContent error;
    private final CommandLineToolLogContent fullOutput;
    private final Supplier<String> displayName;

    @Override
    public CommandLineToolLogContent getStandardOutput() {
        return this.output;
    }

    @Override
    public CommandLineToolLogContent getErrorOutput() {
        return this.error;
    }

    @Override
    public CommandLineToolLogContent getOutput() {
        return this.fullOutput;
    }

    @Override
    public CommandLineToolExecutionResult assertExitValueEquals(int expectedExitValue) throws ExecException {
        if (this.exitValue != expectedExitValue) {
            throw new ExecException(String.format("Process '%s' finished with unexpected exit value %d, was expecting %d", this.displayName.get(), this.exitValue, expectedExitValue));
        }
        return this;
    }

    @Override
    public CommandLineToolExecutionResult assertNormalExitValue() throws ExecException {
        if (this.exitValue != 0) {
            throw new ExecException(String.format("Process '%s' finished with non-zero exit value %d\n%s", this.displayName.get(), this.exitValue, this.error.getAsString()));
        }
        return this;
    }

    public DefaultCommandLineToolExecutionResult(int exitValue, CommandLineToolLogContent output, CommandLineToolLogContent error, CommandLineToolLogContent fullOutput, Supplier<String> displayName) {
        this.exitValue = exitValue;
        this.output = output;
        this.error = error;
        this.fullOutput = fullOutput;
        this.displayName = displayName;
    }

    @Override
    public int getExitValue() {
        return this.exitValue;
    }
}

