/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;

public final class ConfigureUtils {
    private static BiConsumer<Object, DisplayName> attachDisplayName;
    private static BiConsumer<Object, DisplayName> ATTACH_DISPLAY_NAME_IDENTITY;

    private ConfigureUtils() {
    }

    public static <T> void setPropertyValue(Property<T> self, Object value) {
        ((PropertyInternal)self).setFromAnyValue(value);
    }

    public static <T> void setPropertyValue(SetProperty<T> self, Object value) {
        ((PropertyInternal)self).setFromAnyValue(value);
    }

    public static <T> void setPropertyValue(ListProperty<T> self, Object value) {
        ((PropertyInternal)self).setFromAnyValue(value);
    }

    public static <T> Property<T> configureDisplayName(Property<T> self, String propertyName) {
        ConfigureUtils.attachDisplayName(self, Describables.of((Object)("property '" + propertyName + "'")));
        return self;
    }

    public static RegularFileProperty configureDisplayName(RegularFileProperty self, String propertyName) {
        ConfigureUtils.attachDisplayName(self, Describables.of((Object)("property '" + propertyName + "'")));
        return self;
    }

    public static DirectoryProperty configureDisplayName(DirectoryProperty self, String propertyName) {
        ConfigureUtils.attachDisplayName(self, Describables.of((Object)("property '" + propertyName + "'")));
        return self;
    }

    public static <T> SetProperty<T> configureDisplayName(SetProperty<T> self, String propertyName) {
        ConfigureUtils.attachDisplayName(self, Describables.of((Object)("property '" + propertyName + "'")));
        return self;
    }

    public static <T> ListProperty<T> configureDisplayName(ListProperty<T> self, String propertyName) {
        ConfigureUtils.attachDisplayName(self, Describables.of((Object)("property '" + propertyName + "'")));
        return self;
    }

    private static void attachDisplayName(Object obj, DisplayName displayName) {
        if (attachDisplayName == null) {
            attachDisplayName = ConfigureUtils.findAttachOwnerMethod().orElseGet(() -> ConfigureUtils.findAttachDisplayNameMethod().orElse(ATTACH_DISPLAY_NAME_IDENTITY));
        }
        attachDisplayName.accept(obj, displayName);
    }

    private static Optional<BiConsumer<Object, DisplayName>> findAttachDisplayNameMethod() {
        try {
            Class<?> OwnerAware = Class.forName("org.gradle.api.internal.provider.OwnerAware");
            Method method = OwnerAware.getMethod("attachDisplayName", DisplayName.class);
            return Optional.of((obj, arg) -> {
                try {
                    method.invoke(obj, arg);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    attachDisplayName = ATTACH_DISPLAY_NAME_IDENTITY;
                }
            });
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    private static Optional<BiConsumer<Object, DisplayName>> findAttachOwnerMethod() {
        try {
            Class<?> OwnerAware = Class.forName("org.gradle.internal.state.OwnerAware");
            Class<?> ModelObject = Class.forName("org.gradle.internal.state.ModelObject");
            Method method = OwnerAware.getMethod("attachOwner", ModelObject, DisplayName.class);
            return Optional.of((obj, arg) -> {
                try {
                    method.invoke(obj, null, arg);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    attachDisplayName = ATTACH_DISPLAY_NAME_IDENTITY;
                }
            });
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    static {
        ATTACH_DISPLAY_NAME_IDENTITY = (obj, arg) -> {};
    }
}

