/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.Action;

public final class TransformerUtils {
    private TransformerUtils() {
    }

    public static <T> Transformer<T, T> noOpTransformer() {
        return NoOpTransformer.INSTANCE;
    }

    public static <T> Transformer<List<T>, Iterable<T>> toListTransformer() {
        return ToListTransformer.INSTANCE;
    }

    public static <T> Transformer<Set<T>, Iterable<T>> toSetTransformer() {
        return ToSetTransformer.INSTANCE;
    }

    public static <OUT, IN> Transformer<Set<OUT>, Iterable<IN>> toSetTransformer(Class<OUT> type) {
        return ToSetTransformer.INSTANCE;
    }

    public static <T, U> Transformer<T, U> constant(T value) {
        return new ConstantTransformer<T>(value);
    }

    public static <T> Transformer<T, T> configureInPlace(Action<? super T> action) {
        return new ConfigureInPlaceTransformer<T>(action);
    }

    public static <OUT, IN> Transformer<List<OUT>, Iterable<IN>> flatTransformEach(org.gradle.api.Transformer<? extends Iterable<OUT>, ? super IN> mapper) {
        return new FlatTransformEachAdapter(mapper);
    }

    public static <OUT, IN> Transformer<List<OUT>, Iterable<IN>> transformEach(org.gradle.api.Transformer<? extends OUT, ? super IN> mapper) {
        return new TransformEachAdapter<OUT, IN>(mapper);
    }

    public static <A, B, C> Transformer<C, A> compose(org.gradle.api.Transformer<C, B> g, org.gradle.api.Transformer<? extends B, A> f) {
        return new ComposeTransformer<A, B, C>(g, f);
    }

    @FunctionalInterface
    public static interface Transformer<OUT, IN>
    extends org.gradle.api.Transformer<OUT, IN> {
        default public <V> Transformer<OUT, V> compose(Transformer<? extends IN, ? super V> before) {
            return new ComposeTransformer(this, before);
        }

        default public <V> Transformer<V, IN> andThen(Transformer<? extends V, ? super OUT> after) {
            return new ComposeTransformer(after, this);
        }
    }

    private static final class ComposeTransformer<A, B, C>
    implements Transformer<C, A> {
        private final org.gradle.api.Transformer<? extends C, ? super B> g;
        private final org.gradle.api.Transformer<? extends B, ? super A> f;

        public ComposeTransformer(org.gradle.api.Transformer<? extends C, ? super B> g, org.gradle.api.Transformer<? extends B, ? super A> f) {
            this.g = Objects.requireNonNull(g);
            this.f = Objects.requireNonNull(f);
        }

        public C transform(A in) {
            return (C)this.g.transform(this.f.transform(in));
        }

        public String toString() {
            return "TransformerUtils.compose(" + this.g + ", " + this.f + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComposeTransformer)) {
                return false;
            }
            ComposeTransformer other = (ComposeTransformer)o;
            org.gradle.api.Transformer<C, B> this$g = this.g;
            org.gradle.api.Transformer<? extends C, ? super B> other$g = other.g;
            if (this$g == null ? other$g != null : !this$g.equals(other$g)) {
                return false;
            }
            org.gradle.api.Transformer<B, A> this$f = this.f;
            org.gradle.api.Transformer<? extends B, ? super A> other$f = other.f;
            return !(this$f == null ? other$f != null : !this$f.equals(other$f));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            org.gradle.api.Transformer<C, B> $g = this.g;
            result = result * 59 + ($g == null ? 43 : $g.hashCode());
            org.gradle.api.Transformer<B, A> $f = this.f;
            result = result * 59 + ($f == null ? 43 : $f.hashCode());
            return result;
        }
    }

    private static final class TransformEachAdapter<OUT, IN>
    implements Transformer<List<OUT>, Iterable<IN>> {
        private final org.gradle.api.Transformer<? extends OUT, ? super IN> mapper;

        public TransformEachAdapter(org.gradle.api.Transformer<? extends OUT, ? super IN> mapper) {
            this.mapper = Objects.requireNonNull(mapper);
        }

        public List<OUT> transform(Iterable<IN> elements) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (IN element : elements) {
                result.add(this.mapper.transform(element));
            }
            return result.build();
        }

        public String toString() {
            return "TransformerUtils.transformEach(" + this.mapper + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransformEachAdapter)) {
                return false;
            }
            TransformEachAdapter other = (TransformEachAdapter)o;
            org.gradle.api.Transformer<OUT, IN> this$mapper = this.mapper;
            org.gradle.api.Transformer<? extends OUT, ? super IN> other$mapper = other.mapper;
            return !(this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            org.gradle.api.Transformer<OUT, IN> $mapper = this.mapper;
            result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
            return result;
        }
    }

    private static final class FlatTransformEachAdapter<OUT, IN>
    implements Transformer<List<OUT>, Iterable<IN>> {
        private final org.gradle.api.Transformer<? extends Iterable<OUT>, ? super IN> mapper;

        public FlatTransformEachAdapter(org.gradle.api.Transformer<? extends Iterable<OUT>, ? super IN> mapper) {
            this.mapper = Objects.requireNonNull(mapper);
        }

        public List<OUT> transform(Iterable<IN> elements) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (IN element : elements) {
                result.addAll((Iterable)this.mapper.transform(element));
            }
            return result.build();
        }

        public String toString() {
            return "TransformerUtils.flatTransformEach(" + this.mapper + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FlatTransformEachAdapter)) {
                return false;
            }
            FlatTransformEachAdapter other = (FlatTransformEachAdapter)o;
            org.gradle.api.Transformer<Iterable<OUT>, IN> this$mapper = this.mapper;
            org.gradle.api.Transformer<? extends Iterable<OUT>, ? super IN> other$mapper = other.mapper;
            return !(this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            org.gradle.api.Transformer<Iterable<OUT>, IN> $mapper = this.mapper;
            result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
            return result;
        }
    }

    private static final class ConfigureInPlaceTransformer<T>
    implements Transformer<T, T> {
        private final Action<? super T> action;

        public ConfigureInPlaceTransformer(Action<? super T> action) {
            this.action = action;
        }

        public T transform(T t) {
            this.action.execute(t);
            return t;
        }

        public String toString() {
            return "TransformerUtils.configureInPlace(" + this.action + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigureInPlaceTransformer)) {
                return false;
            }
            ConfigureInPlaceTransformer other = (ConfigureInPlaceTransformer)o;
            Action<T> this$action = this.action;
            Action<? super T> other$action = other.action;
            return !(this$action == null ? other$action != null : !this$action.equals(other$action));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Action<T> $action = this.action;
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            return result;
        }
    }

    private static final class ConstantTransformer<T>
    implements Transformer<T, Object> {
        private final T value;

        public ConstantTransformer(T value) {
            this.value = value;
        }

        public T transform(Object o) {
            return this.value;
        }

        public String toString() {
            return "TransformerUtils.constant(" + this.value + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstantTransformer)) {
                return false;
            }
            ConstantTransformer other = (ConstantTransformer)o;
            T this$value = this.value;
            T other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $value = this.value;
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }

    private static enum ToSetTransformer implements Transformer<Set<? extends Object>, Iterable<? extends Object>>
    {
        INSTANCE;


        public Set<?> transform(Iterable<?> objects) {
            return ImmutableSet.copyOf(objects);
        }

        public String toString() {
            return "TransformerUtils.toSetTransformer()";
        }
    }

    private static enum ToListTransformer implements Transformer<List<? extends Object>, Iterable<? extends Object>>
    {
        INSTANCE;


        public List<?> transform(Iterable<?> objects) {
            return ImmutableList.copyOf(objects);
        }

        public String toString() {
            return "TransformerUtils.toListTransformer()";
        }
    }

    private static enum NoOpTransformer implements Transformer<Object, Object>
    {
        INSTANCE;


        public Object transform(Object o) {
            return o;
        }

        public String toString() {
            return "TransformerUtils.noOpTransformer()";
        }
    }
}

