/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.ansi.console;

import net.rubygrapefruit.ansi.Visitor;
import net.rubygrapefruit.ansi.token.CarriageReturn;
import net.rubygrapefruit.ansi.token.NewLine;
import net.rubygrapefruit.ansi.token.Text;
import net.rubygrapefruit.ansi.token.Token;

public class DiagnosticConsole
implements Visitor {
    private final StringBuilder result = new StringBuilder();
    private Token last;

    @Override
    public void visit(Token token) {
        if (token instanceof NewLine) {
            if (this.last instanceof CarriageReturn) {
                this.result.replace(this.result.length() - 4, this.result.length(), "\n");
            } else {
                this.result.append('\n');
            }
        } else if (token instanceof Text) {
            this.result.append(((Text)token).getText());
        } else {
            token.appendDiagnostic(this.result);
        }
        this.last = token;
    }

    public <T extends Visitor> T contents(T visitor) {
        visitor.visit(new Text(this.result.toString()));
        return visitor;
    }

    public String toString() {
        return this.result.toString();
    }
}

