/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.core.exec.internal;

import com.google.common.base.Preconditions;
import dev.nokee.core.exec.CommandLineTool;
import dev.nokee.core.exec.CommandLineToolProvider;
import java.util.function.Supplier;

public class SupplierCommandLineToolProvider
implements CommandLineToolProvider {
    private Supplier<CommandLineTool> toolSupplier;
    private CommandLineTool suppliedTool;

    public SupplierCommandLineToolProvider(Supplier<CommandLineTool> toolSupplier) {
        this.toolSupplier = (Supplier)Preconditions.checkNotNull(toolSupplier);
    }

    @Override
    public CommandLineTool get() {
        try {
            if (this.isAvailableAndPassAlongExceptions()) {
                return this.suppliedTool;
            }
            throw new IllegalArgumentException("Don't know how to provide this tool.");
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Don't know how to provide this tool.", ex);
        }
    }

    private boolean isAvailableAndPassAlongExceptions() {
        this.resolveTool();
        return this.suppliedTool != null;
    }

    @Override
    public boolean isAvailable() {
        try {
            return this.isAvailableAndPassAlongExceptions();
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private void resolveTool() {
        if (this.toolSupplier != null) {
            this.suppliedTool = this.toolSupplier.get();
            this.toolSupplier = null;
        }
    }
}

