/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.utils;

import com.google.common.collect.ImmutableList;
import dev.nokee.utils.Cast;
import dev.nokee.utils.TransformerUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.util.GradleVersion;

public final class ProviderUtils {
    private ProviderUtils() {
    }

    public static <T> Provider<T> fixed(T value) {
        return Providers.of(Objects.requireNonNull(value));
    }

    public static <T> Provider<T> supplied(Callable<T> callable) {
        return new DefaultProvider(Objects.requireNonNull(callable));
    }

    public static <T> Provider<T> notDefined() {
        return Providers.notDefined();
    }

    @Nullable
    public static <T> Class<T> getType(Provider<T> self) {
        Objects.requireNonNull(self);
        if (self instanceof ProviderInternal) {
            return ((ProviderInternal)self).getType();
        }
        return null;
    }

    public static <T> Transformer<List<T>, Iterable<T>> filter(Spec<? super T> spec) {
        if (Specs.satisfyAll().equals(spec)) {
            return TransformerUtils.toListTransformer();
        }
        if (Specs.satisfyNone().equals(spec)) {
            return TransformerUtils.constant(Collections.emptyList());
        }
        return new GradleCollectionProviderFilterAdapter<T>(spec);
    }

    public static <S> Provider<S> forUseAtConfigurationTime(Provider<S> provider) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.5")) >= 0) {
            try {
                Method method = Provider.class.getMethod("forUseAtConfigurationTime", new Class[0]);
                return (Provider)Cast.uncheckedCast("using reflection to support newer Gradle", method.invoke(provider, new Object[0]));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Could not mark provider usage for configuration time because of an exception.", e);
            }
        }
        return provider;
    }

    private static final class GradleCollectionProviderFilterAdapter<T>
    implements Transformer<List<T>, Iterable<T>> {
        private final Spec<? super T> spec;

        public GradleCollectionProviderFilterAdapter(Spec<? super T> spec) {
            this.spec = Objects.requireNonNull(spec);
        }

        public List<T> transform(Iterable<T> elements) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (T element : elements) {
                if (!this.spec.isSatisfiedBy(element)) continue;
                result.add(element);
            }
            return result.build();
        }

        public String toString() {
            return "ProviderUtils.filter(" + this.spec + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleCollectionProviderFilterAdapter)) {
                return false;
            }
            GradleCollectionProviderFilterAdapter other = (GradleCollectionProviderFilterAdapter)o;
            Spec<T> this$spec = this.spec;
            Spec<? super T> other$spec = other.spec;
            return !(this$spec == null ? other$spec != null : !this$spec.equals(other$spec));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Spec<T> $spec = this.spec;
            result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
            return result;
        }
    }
}

