/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.fixtures.runnerkit;

import dev.gradleplugins.runnerkit.BuildResult;
import dev.gradleplugins.runnerkit.BuildTask;
import dev.gradleplugins.runnerkit.TaskOutcome;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class BuildResultMatchers {
    private BuildResultMatchers() {
    }

    public static Matcher<BuildResult> hasFailureCause(String cause) {
        return BuildResultMatchers.hasFailureCause((Matcher<? super String>)Matchers.startsWith((String)cause));
    }

    public static Matcher<BuildResult> hasFailureCause(Matcher<? super String> matcher) {
        return new FailureCause(matcher);
    }

    public static Matcher<BuildResult> hasFailureDescription(String description) {
        return BuildResultMatchers.hasFailureDescription((Matcher<? super String>)Matchers.startsWith((String)description));
    }

    public static Matcher<BuildResult> hasFailureDescription(Matcher<? super String> matcher) {
        return new FailureDescription(matcher);
    }

    public static Matcher<BuildResult> tasksExecuted(Object ... taskPaths) {
        return new TasksExecuted(BuildResultMatchers.flattenTaskPaths(taskPaths));
    }

    public static Matcher<BuildResult> tasksSkipped(Object ... taskPaths) {
        return new TasksSkipped(BuildResultMatchers.flattenTaskPaths(taskPaths));
    }

    public static Matcher<BuildResult> tasksExecutedAndNotSkipped(Object ... taskPaths) {
        return new TasksExecutedAndNotSkipped(BuildResultMatchers.flattenTaskPaths(taskPaths));
    }

    public static List<String> flattenTaskPaths(Object[] taskPaths) {
        ArrayList<String> result = new ArrayList<String>();
        BuildResultMatchers.flattenTaskPaths(Arrays.asList(taskPaths), result);
        return result;
    }

    private static void flattenTaskPaths(Collection<? super Object> taskPaths, List<String> flattenTaskPaths) {
        taskPaths.stream().forEach(it -> {
            if (it instanceof Collection) {
                BuildResultMatchers.flattenTaskPaths((Collection)it, flattenTaskPaths);
            } else {
                flattenTaskPaths.add(it.toString());
            }
        });
    }

    private static final class TasksExecutedAndNotSkipped
    extends AbstractTaskMatcher {
        TasksExecutedAndNotSkipped(List<String> taskPaths) {
            super("executed and not skipped task paths of ", TasksExecutedAndNotSkipped::getExecutedAndNotSkippedTaskPaths, taskPaths);
        }

        private static List<String> getExecutedAndNotSkippedTaskPaths(BuildResult item) {
            return item.getTasks().stream().filter(TasksExecutedAndNotSkipped::isExecutedAndNotSkipped).map(BuildTask::getPath).collect(Collectors.toList());
        }

        private static boolean isExecutedAndNotSkipped(BuildTask buildTask) {
            return buildTask.getOutcome().equals((Object)TaskOutcome.SUCCESS) || buildTask.getOutcome().equals((Object)TaskOutcome.FAILED);
        }
    }

    private static final class TasksSkipped
    extends AbstractTaskMatcher {
        TasksSkipped(List<String> taskPaths) {
            super("skipped task paths of ", BuildResult::getSkippedTaskPaths, taskPaths);
        }
    }

    private static final class TasksExecuted
    extends AbstractTaskMatcher {
        TasksExecuted(List<String> taskPaths) {
            super("executed task paths of ", BuildResult::getExecutedTaskPaths, taskPaths);
        }
    }

    private static abstract class AbstractTaskMatcher
    extends TypeSafeDiagnosingMatcher<BuildResult> {
        private final String description;
        private final Function<BuildResult, List<String>> extractTaskPaths;
        private final Matcher<Iterable<? extends String>> matcher;

        AbstractTaskMatcher(String description, Function<BuildResult, List<String>> extractTaskPaths, List<String> expectedTasks) {
            MatcherAssert.assertThat((String)"all expected task paths must be valid task paths", expectedTasks, (Matcher)Matchers.everyItem((Matcher)Matchers.startsWith((String)":")));
            this.description = description;
            this.extractTaskPaths = extractTaskPaths;
            this.matcher = Matchers.containsInAnyOrder((Collection)expectedTasks.stream().map(Matchers::equalTo).collect(Collectors.toList()));
        }

        protected boolean matchesSafely(BuildResult item, Description mismatchDescription) {
            List<String> actualTasks = this.extractTaskPaths.apply(item);
            if (!this.matcher.matches(actualTasks)) {
                this.matcher.describeMismatch(actualTasks, mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(this.description).appendDescriptionOf(this.matcher);
        }
    }

    private static final class FailureDescription
    extends TypeSafeDiagnosingMatcher<BuildResult> {
        private final Matcher<? super String> matcher;

        FailureDescription(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("a failure description matching ").appendDescriptionOf(this.matcher);
        }

        protected boolean matchesSafely(BuildResult item, Description mismatchDescription) {
            for (BuildResult.Failure failure : item.getFailures()) {
                if (!this.matcher.matches((Object)failure.getDescription())) continue;
                return true;
            }
            mismatchDescription.appendValueList("none of the following description matches: ", ", ", "", (Iterable)item.getFailures().stream().map(BuildResult.Failure::getDescription).distinct().collect(Collectors.toList()));
            return false;
        }
    }

    private static final class FailureCause
    extends TypeSafeDiagnosingMatcher<BuildResult> {
        private final Matcher<? super String> matcher;

        FailureCause(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(BuildResult item, Description mismatchDescription) {
            for (BuildResult.Failure failure : item.getFailures()) {
                for (String cause : failure.getCauses()) {
                    if (!this.matcher.matches((Object)cause)) continue;
                    return true;
                }
            }
            mismatchDescription.appendValueList("none of the following causes matches: ", ", ", "", (Iterable)item.getFailures().stream().flatMap(it -> it.getCauses().stream()).distinct().collect(Collectors.toList()));
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("a failure cause matching ").appendDescriptionOf(this.matcher);
        }
    }
}

