/*
 * Copyright 2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.internal.snapshot

import spock.lang.Specification
import spock.lang.Unroll

@Unroll
class SearchUtilTest extends Specification {

    def "search for #searchedChild in #sortedChildren is #expectedResult"() {
        expect:
        SearchUtil.binarySearch(children, searchedChild) == expectedResult

        where:
        children | searchedChild
        ["a", "b", "ba", "bb", "cc"] | "b"
        ["a", "b", "ba", "bb", "cc"] | "baa"
        []                           | "baa"
        ["b"]                        | "a"
        ["a"]                        | "b"
        ["a"]                        | "a"

        sortedChildren = children.toSorted()
        expectedResult = Collections.binarySearch(sortedChildren, searchedChild)
    }
}
