/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.site.base.internal;

import dev.gradleplugins.documentationkit.site.base.SiteExtension;
import dev.gradleplugins.documentationkit.site.base.Sitemap;
import dev.gradleplugins.documentationkit.site.base.tasks.GenerateRobots;
import dev.gradleplugins.documentationkit.site.base.tasks.GenerateSitemap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class SiteBasePlugin
implements Plugin<Project> {
    private final TaskContainer tasks;

    @Inject
    public SiteBasePlugin(TaskContainer tasks) {
        this.tasks = tasks;
    }

    public void apply(Project project) {
        TaskProvider robotsTask = this.tasks.register("robots", GenerateRobots.class, task -> {
            task.setGroup("documentation");
            task.getHost().value(project.provider(() -> SiteBasePlugin.site(project).map(it -> (String)it.getHost().getOrNull()).orElse(null))).disallowChanges();
            task.getGeneratedRobotsFile().value(project.getLayout().getBuildDirectory().file("tmp/" + task.getName() + "/robots.txt")).disallowChanges();
        });
        TaskProvider sitemapTask = this.tasks.register("sitemap", GenerateSitemap.class, task -> {
            task.dependsOn(new Object[]{() -> {
                Optional<SiteExtension> extension = SiteBasePlugin.site(project);
                if (extension.isPresent()) {
                    return extension.get().getSources();
                }
                return Collections.emptyList();
            }});
            task.setGroup("documentation");
            task.getGeneratedSitemapFile().value(project.getLayout().getBuildDirectory().file("tmp/" + task.getName() + "/sitemap.xml")).disallowChanges();
            task.getSitemapUrls().addAll(project.provider(() -> {
                final ArrayList urls = new ArrayList();
                SiteBasePlugin.site(project).ifPresent(site -> site.getSources().getAsFileTree().visit(new FileVisitor((SiteExtension)site){
                    final /* synthetic */ SiteExtension val$site;
                    {
                        this.val$site = siteExtension;
                    }

                    public void visitDir(FileVisitDetails details) {
                    }

                    public void visitFile(FileVisitDetails details) {
                        if (this.isHtml(details)) {
                            try {
                                urls.add(new Sitemap.Url(new URL("https://" + (String)this.val$site.getHost().get() + "/" + this.canonizePath(details)), LocalDate.now()));
                            }
                            catch (MalformedURLException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }

                    private boolean isHtml(FileVisitDetails details) {
                        return details.getName().endsWith(".html");
                    }

                    private String canonizePath(FileVisitDetails details) {
                        RelativePath relativePath = details.getRelativePath();
                        if (relativePath.getLastName().equals("index.html")) {
                            return Optional.ofNullable(relativePath.getParent()).map(RelativePath::getPathString).orElse("");
                        }
                        return relativePath.getPathString();
                    }
                }));
                return urls;
            }));
        });
        TaskProvider stageSiteTask = project.getTasks().register("stageSite", Sync.class, task -> {
            task.from(new Object[]{robotsTask.flatMap(GenerateRobots::getGeneratedRobotsFile)});
            task.from(new Object[]{sitemapTask.flatMap(GenerateSitemap::getGeneratedSitemapFile)});
            task.from(new Object[]{() -> SiteBasePlugin.site(project).map(SiteExtension::getSources).map(Collections::singletonList).orElseGet(Collections::emptyList)});
            task.setDestinationDir(((Directory)project.getLayout().getBuildDirectory().dir("site").get()).getAsFile());
            task.setIncludeEmptyDirs(false);
            task.doFirst(t -> SiteBasePlugin.site(project).ifPresent(site -> ((Map)site.getSymbolicLinks().get()).keySet().forEach(src -> {
                try {
                    Files.deleteIfExists(task.getDestinationDir().toPath().resolve((String)src));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            })));
            task.doLast(t -> SiteBasePlugin.site(project).ifPresent(site -> ((Map)site.getSymbolicLinks().get()).forEach((src, dst) -> {
                try {
                    Files.createSymbolicLink(task.getDestinationDir().toPath().resolve((String)src), Paths.get(dst, new String[0]), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            })));
        });
        project.getTasks().register("site", task -> {
            task.dependsOn(new Object[]{stageSiteTask});
            task.setGroup("documentation");
            task.setDescription("Assemble your site");
        });
    }

    private static Optional<SiteExtension> site(Project project) {
        return Optional.ofNullable(project.getExtensions().findByName("site")).map(SiteExtension.class::cast);
    }
}

