/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.site.base.tasks;

import dev.gradleplugins.documentationkit.site.base.Sitemap;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateSitemap
extends DefaultTask {
    @Input
    public abstract SetProperty<Sitemap.Url> getSitemapUrls();

    @OutputFile
    public abstract RegularFileProperty getGeneratedSitemapFile();

    @TaskAction
    private void doGenerate() throws IOException, XMLStreamException {
        try (SitemapWriter writer = new SitemapWriter(Files.newBufferedWriter(((RegularFile)this.getGeneratedSitemapFile().get()).getAsFile().toPath(), new OpenOption[0]));){
            writer.write(new Sitemap((Collection)this.getSitemapUrls().get()));
        }
    }

    private static final class SitemapWriter
    implements AutoCloseable {
        private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        private final XMLStreamWriter writer;

        private SitemapWriter(Writer writer) throws XMLStreamException {
            this.writer = XMLOutputFactory.newFactory().createXMLStreamWriter(writer);
        }

        public void write(Sitemap sitemap) throws XMLStreamException {
            this.writer.writeStartDocument("1.0");
            this.writer.writeStartElement("urlset");
            this.writer.writeNamespace("xmlns", "http://www.sitemaps.org/schemas/sitemap/0.9");
            for (Sitemap.Url url : sitemap) {
                this.writeUrl(url);
            }
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
            this.writer.flush();
        }

        private void writeUrl(Sitemap.Url url) throws XMLStreamException {
            this.writer.writeStartElement("url");
            this.writer.writeStartElement("loc");
            this.writer.writeCharacters(url.getLocation().toString());
            this.writer.writeEndElement();
            if (url.getLastModified() != null) {
                this.writer.writeStartElement("lastmod");
                this.writer.writeCharacters(DATE_FORMAT.format(url.getLastModified()));
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
        }

        @Override
        public void close() throws XMLStreamException {
            this.writer.close();
        }
    }
}

