/*
 * Decompiled with CFR 0.152.
 */
package dev.grmek.maven;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dev.grmek.maven.EnumConfiguration;
import dev.grmek.maven.FieldConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.apache.commons.text.CaseUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class BuildConfigMojo
extends AbstractMojo {
    private static final List<String> DEFAULT_INCLUDES = Arrays.asList(String.class.getName(), Integer.class.getName(), Long.class.getName(), Short.class.getName(), Byte.class.getName(), Float.class.getName(), Double.class.getName(), Boolean.class.getName(), Character.class.getName(), CharSequence.class.getName(), Object.class.getName());
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(required=true)
    private List<FieldConfiguration> fields = new ArrayList<FieldConfiguration>();
    @Parameter(defaultValue="BuildConfig")
    private String className;
    @Parameter(defaultValue="true")
    private boolean finalClass;
    @Parameter(defaultValue="false")
    private boolean includeArtifactIdInPackageName;
    @Parameter
    private Set<String> includes = new TreeSet<String>();
    @Parameter(defaultValue="${project.build.directory}${file.separator}generated-sources")
    private File outputDirectory;
    @Parameter(defaultValue="${project.groupId}", required=true)
    private String packageName;
    @Parameter
    private List<EnumConfiguration> enums = new ArrayList<EnumConfiguration>();

    private String getPackageName() {
        return this.includeArtifactIdInPackageName ? String.join((CharSequence)".", this.packageName, this.getArtifactId()) : this.packageName;
    }

    private String getArtifactId() {
        return CaseUtils.toCamelCase((String)this.project.getArtifactId(), (boolean)false, (char[])new char[]{'-', '_', '.'});
    }

    private List<TypeName> getIncludeTypeNames() {
        return Stream.concat(DEFAULT_INCLUDES.stream(), this.includes.stream()).distinct().map(ClassName::bestGuess).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void prepareOutDir() throws MojoExecutionException {
        if (!(this.outputDirectory.exists() || this.outputDirectory.mkdirs() || this.outputDirectory.exists())) {
            throw new MojoExecutionException(String.format(Locale.US, "Error creating out folder %s", this.outputDirectory.getAbsolutePath()));
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
    }

    private TypeSpec buildConfig() {
        Modifier[] modifierArray;
        if (this.finalClass) {
            Modifier[] modifierArray2 = new Modifier[2];
            modifierArray2[0] = Modifier.PUBLIC;
            modifierArray = modifierArray2;
            modifierArray2[1] = Modifier.FINAL;
        } else {
            Modifier[] modifierArray3 = new Modifier[1];
            modifierArray = modifierArray3;
            modifierArray3[0] = Modifier.PUBLIC;
        }
        Modifier[] modifiers = modifierArray;
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.className).addModifiers(modifiers);
        List<TypeName> localIncludes = this.getIncludeTypeNames();
        if (!this.enums.isEmpty()) {
            this.getLog().info((CharSequence)"Building enums:");
            this.enums.forEach(it -> builder.addType(this.buildEnum((EnumConfiguration)it, localIncludes)));
        }
        this.getLog().info((CharSequence)"Building fields:");
        this.fields.forEach(it -> builder.addField(this.buildField((FieldConfiguration)it, localIncludes)));
        return builder.build();
    }

    private TypeSpec buildEnum(EnumConfiguration enumConfiguration, List<TypeName> localIncludes) {
        this.getLog().info((CharSequence)String.format(Locale.US, "  - adding enum %s %s", enumConfiguration.getName(), enumConfiguration.getConstants()));
        this.validateEnumConfiguration(enumConfiguration);
        TypeSpec.Builder builder = TypeSpec.enumBuilder((String)enumConfiguration.getName()).addModifiers(enumConfiguration.getModifiers());
        enumConfiguration.getConstants().forEach(arg_0 -> ((TypeSpec.Builder)builder).addEnumConstant(arg_0));
        TypeSpec result = builder.build();
        localIncludes.add((TypeName)ClassName.bestGuess((String)enumConfiguration.getName()));
        return result;
    }

    private void validateEnumConfiguration(EnumConfiguration enumConfiguration) {
        if (enumConfiguration.getName() == null) {
            throw new RuntimeException("Parameter 'name' is required in enum definition");
        }
        if (enumConfiguration.getConstants().isEmpty()) {
            throw new RuntimeException("Parameter 'constants' is required in enum definition");
        }
    }

    private FieldSpec buildField(FieldConfiguration fieldConfiguration, List<TypeName> localIncludes) {
        this.getLog().info((CharSequence)String.format(Locale.US, "  - adding field %s %s", fieldConfiguration.getType(), fieldConfiguration.getName()));
        this.validateFieldConfiguration(fieldConfiguration);
        TypeName typeName = this.getTypeName(fieldConfiguration.getType(), localIncludes);
        FieldSpec.Builder spec = FieldSpec.builder((TypeName)typeName, (String)fieldConfiguration.getName(), (Modifier[])new Modifier[0]).addModifiers(fieldConfiguration.getModifiers());
        EnumConfiguration enumType = this.getEnumType(typeName);
        if (enumType != null) {
            if (!enumType.getConstants().contains(fieldConfiguration.getValue())) {
                throw new RuntimeException(String.format(Locale.US, "Value '%s' of field '%s' is not one of enum type '%s'. Available values %s", fieldConfiguration.getValue(), fieldConfiguration.getName(), enumType.getName(), enumType.getConstants()));
            }
            spec.initializer("$T.$L", new Object[]{typeName, fieldConfiguration.getValue()});
        } else {
            spec.initializer(fieldConfiguration.getValue(), new Object[0]);
        }
        fieldConfiguration.getComment().ifPresent(x$0 -> spec.addJavadoc(x$0, new Object[0]));
        return spec.build();
    }

    private void validateFieldConfiguration(FieldConfiguration fieldConfiguration) {
        if (fieldConfiguration.getName() == null) {
            throw new RuntimeException("Parameter 'name' is required in field definition");
        }
        if (fieldConfiguration.getType() == null) {
            throw new RuntimeException("Parameter 'type' is required in field definition");
        }
        if (fieldConfiguration.getValue() == null) {
            throw new RuntimeException("Parameter 'value' is required in field definition");
        }
    }

    private EnumConfiguration getEnumType(TypeName typeName) {
        ClassName className;
        if (typeName instanceof ClassName && (className = (ClassName)typeName).packageName().isEmpty()) {
            return this.enums.stream().filter(it -> it.getName().equals(className.simpleName())).findFirst().orElse(null);
        }
        return null;
    }

    private TypeName getTypeName(String type, List<TypeName> localIncludes) {
        return this.getPrimitiveTypeName(type).orElseGet(() -> localIncludes.stream().filter(it -> it instanceof ClassName).map(it -> (ClassName)it).filter(it -> it.simpleName().equals(type)).findFirst().orElseThrow(() -> new RuntimeException(String.format(Locale.US, "Can't find class '%s'. Please include it in 'includes' section. Current available includes: %s", type, localIncludes.stream().map(it -> ((ClassName)it).canonicalName())))));
    }

    private Optional<TypeName> getPrimitiveTypeName(String type) {
        switch (type) {
            case "int": {
                return Optional.of(TypeName.INT);
            }
            case "long": {
                return Optional.of(TypeName.LONG);
            }
            case "short": {
                return Optional.of(TypeName.SHORT);
            }
            case "byte": {
                return Optional.of(TypeName.BYTE);
            }
            case "float": {
                return Optional.of(TypeName.FLOAT);
            }
            case "double": {
                return Optional.of(TypeName.DOUBLE);
            }
            case "boolean": {
                return Optional.of(TypeName.BOOLEAN);
            }
            case "char": {
                return Optional.of(TypeName.CHAR);
            }
        }
        return Optional.empty();
    }

    public void execute() throws MojoExecutionException {
        try {
            String packageName = this.getPackageName();
            this.getLog().info((CharSequence)String.format(Locale.US, "Creating class %s.%s", packageName, this.className));
            TypeSpec buildConfigSpec = this.buildConfig();
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)buildConfigSpec).build();
            this.prepareOutDir();
            this.getLog().info((CharSequence)String.format(Locale.US, "Output directory %s", this.outputDirectory.getAbsolutePath()));
            javaFile.writeTo(this.outputDirectory);
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException(e.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

