/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.SimpleType;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class JacksonNode
implements JsonNode {
    private final com.fasterxml.jackson.databind.JsonNode node;
    private final String jsonPointer;
    private final SimpleType nodeType;

    private JacksonNode(com.fasterxml.jackson.databind.JsonNode node, String jsonPointer) {
        this.node = Objects.requireNonNull(node);
        this.jsonPointer = Objects.requireNonNull(jsonPointer);
        this.nodeType = JacksonNode.computeNodeType(node);
    }

    public JacksonNode(com.fasterxml.jackson.databind.JsonNode node) {
        this(node, "");
    }

    @Override
    public String getJsonPointer() {
        return this.jsonPointer;
    }

    @Override
    public SimpleType getNodeType() {
        return this.nodeType;
    }

    @Override
    public boolean asBoolean() {
        return this.node.asBoolean();
    }

    @Override
    public String asString() {
        return this.node.asText();
    }

    @Override
    public BigInteger asInteger() {
        return this.node.bigIntegerValue();
    }

    @Override
    public BigDecimal asNumber() {
        return this.node.decimalValue();
    }

    @Override
    public List<JsonNode> asArray() {
        ArrayList<JsonNode> elements = new ArrayList<JsonNode>();
        Iterator iterator = this.node.elements();
        while (iterator.hasNext()) {
            elements.add(new JacksonNode((com.fasterxml.jackson.databind.JsonNode)iterator.next(), this.jsonPointer + "/" + elements.size()));
        }
        return elements;
    }

    @Override
    public Map<String, JsonNode> asObject() {
        HashMap<String, JsonNode> map = new HashMap<String, JsonNode>();
        Iterator iterator = this.node.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            map.put((String)entry.getKey(), new JacksonNode((com.fasterxml.jackson.databind.JsonNode)entry.getValue(), this.jsonPointer + "/" + JsonNode.encodeJsonPointer((String)entry.getKey())));
        }
        return map;
    }

    private static SimpleType computeNodeType(com.fasterxml.jackson.databind.JsonNode node) {
        if (node.canConvertToExactIntegral()) {
            return SimpleType.INTEGER;
        }
        switch (node.getNodeType()) {
            case NULL: {
                return SimpleType.NULL;
            }
            case BOOLEAN: {
                return SimpleType.BOOLEAN;
            }
            case STRING: {
                return SimpleType.STRING;
            }
            case NUMBER: {
                return SimpleType.NUMBER;
            }
            case ARRAY: {
                return SimpleType.ARRAY;
            }
            case OBJECT: {
                return SimpleType.OBJECT;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown node type [%s]", node.getNodeType()));
    }

    public static final class Factory
    implements JsonNodeFactory {
        private final ObjectMapper mapper;

        public Factory() {
            this(new ObjectMapper().enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS));
        }

        public Factory(ObjectMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        public JacksonNode wrap(Object node) {
            if (node instanceof JacksonNode) {
                return (JacksonNode)node;
            }
            if (node instanceof com.fasterxml.jackson.databind.JsonNode) {
                return new JacksonNode((com.fasterxml.jackson.databind.JsonNode)node);
            }
            throw new IllegalArgumentException("Cannot wrap object which is not an instance of com.fasterxml.jackson.databind.JsonNode");
        }

        @Override
        public JacksonNode create(String rawJson) {
            try {
                return new JacksonNode(this.mapper.readTree(rawJson));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

