/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.SimpleType;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class JakartaJsonNode
implements JsonNode {
    private final JsonValue node;
    private final String jsonPointer;
    private final SimpleType nodeType;

    private JakartaJsonNode(JsonValue node, String jsonPointer) {
        this.node = Objects.requireNonNull(node);
        this.jsonPointer = Objects.requireNonNull(jsonPointer);
        this.nodeType = JakartaJsonNode.computeNodeType(this.node);
    }

    public JakartaJsonNode(JsonValue node) {
        this(node, "");
    }

    @Override
    public String getJsonPointer() {
        return this.jsonPointer;
    }

    @Override
    public SimpleType getNodeType() {
        return this.nodeType;
    }

    @Override
    public boolean asBoolean() {
        return this.node.getValueType() == JsonValue.ValueType.TRUE;
    }

    @Override
    public String asString() {
        return this.node instanceof JsonString ? ((JsonString)this.node).getChars().toString() : this.node.toString();
    }

    @Override
    public BigInteger asInteger() {
        return ((JsonNumber)this.node).bigIntegerValue();
    }

    @Override
    public BigDecimal asNumber() {
        return ((JsonNumber)this.node).bigDecimalValue();
    }

    @Override
    public List<JsonNode> asArray() {
        JsonArray jsonArray = this.node.asJsonArray();
        ArrayList<JsonNode> result = new ArrayList<JsonNode>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            result.add(new JakartaJsonNode((JsonValue)jsonArray.get(i), this.jsonPointer + "/" + i));
        }
        return result;
    }

    @Override
    public Map<String, JsonNode> asObject() {
        Set objectMap = this.node.asJsonObject().entrySet();
        HashMap<String, JsonNode> result = new HashMap<String, JsonNode>(objectMap.size());
        for (Map.Entry entry : objectMap) {
            result.put((String)entry.getKey(), new JakartaJsonNode((JsonValue)entry.getValue(), this.jsonPointer + "/" + JsonNode.encodeJsonPointer((String)entry.getKey())));
        }
        return result;
    }

    private static SimpleType computeNodeType(JsonValue node) {
        switch (node.getValueType()) {
            case NULL: {
                return SimpleType.NULL;
            }
            case ARRAY: {
                return SimpleType.ARRAY;
            }
            case OBJECT: {
                return SimpleType.OBJECT;
            }
            case STRING: {
                return SimpleType.STRING;
            }
            case TRUE: 
            case FALSE: {
                return SimpleType.BOOLEAN;
            }
            case NUMBER: {
                JsonNumber jsonNumber = (JsonNumber)node;
                if (jsonNumber.isIntegral() || jsonNumber.bigDecimalValue().stripTrailingZeros().scale() <= 0) {
                    return SimpleType.INTEGER;
                }
                return SimpleType.NUMBER;
            }
        }
        throw new IllegalArgumentException("Unknown node type=" + node.getValueType());
    }

    public static final class Factory
    implements JsonNodeFactory {
        private final JsonParserFactory parserFactory;

        public Factory() {
            this(Json.createParserFactory(Collections.emptyMap()));
        }

        public Factory(JsonParserFactory parserFactory) {
            this.parserFactory = parserFactory;
        }

        @Override
        public JakartaJsonNode wrap(Object node) {
            if (node instanceof JakartaJsonNode) {
                return (JakartaJsonNode)node;
            }
            if (node instanceof JsonValue) {
                return new JakartaJsonNode((JsonValue)node);
            }
            throw new IllegalArgumentException("Cannot wrap object which is not an instance of jakarta.json.JsonValue");
        }

        @Override
        public JakartaJsonNode create(String rawJson) {
            try (JsonParser parser = this.parserFactory.createParser((Reader)new StringReader(rawJson));){
                parser.next();
                JakartaJsonNode jakartaJsonNode = new JakartaJsonNode(parser.getValue());
                return jakartaJsonNode;
            }
        }
    }
}

