/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.UriUtil;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

final class JsonNodeUtil {
    private JsonNodeUtil() {
    }

    static Optional<Map<String, JsonNode>> getAsObject(JsonNode node) {
        return node.isObject() ? Optional.of(node.asObject()) : Optional.empty();
    }

    static Optional<Boolean> getBooleanField(Map<String, JsonNode> objectMap, String fieldName) {
        return Optional.ofNullable(objectMap.get(fieldName)).filter(JsonNode::isBoolean).map(JsonNode::asBoolean);
    }

    static Optional<String> getStringField(Map<String, JsonNode> objectMap, String fieldName) {
        return Optional.ofNullable(objectMap.get(fieldName)).filter(JsonNode::isString).map(JsonNode::asString);
    }

    static Optional<Map<String, JsonNode>> getObjectField(Map<String, JsonNode> objectMap, String fieldName) {
        return Optional.ofNullable(objectMap.get(fieldName)).filter(JsonNode::isObject).map(JsonNode::asObject);
    }

    static Optional<Map<String, Boolean>> getVocabulariesObject(Map<String, JsonNode> objectNode) {
        return JsonNodeUtil.getObjectField(objectNode, "$vocabulary").map(obj -> obj.entrySet().stream().filter(entry -> ((JsonNode)entry.getValue()).isBoolean()).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JsonNode)entry.getValue()).asBoolean()))).map(Collections::unmodifiableMap);
    }

    static boolean validateIdField(String id) {
        if (UriUtil.hasNonEmptyFragment(URI.create(id))) {
            throw new IllegalArgumentException(String.format("$id [%s] cannot contain non-empty fragments", id));
        }
        return true;
    }
}

