/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

class AdditionalPropertiesEvaluator
implements Evaluator {
    private final CompoundUri schemaRef;

    AdditionalPropertiesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getCompoundUri(node);
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        Object patternAnnotation;
        if (!node.isObject()) {
            return Evaluator.Result.success();
        }
        String instanceLocation = node.getJsonPointer();
        HashMap<String, JsonNode> toBeProcessed = new HashMap<String, JsonNode>(node.asObject());
        Object propsAnnotation = ctx.getSiblingAnnotation("properties", instanceLocation);
        if (propsAnnotation instanceof Collection) {
            toBeProcessed.keySet().removeAll((Collection)propsAnnotation);
        }
        if ((patternAnnotation = ctx.getSiblingAnnotation("patternProperties", instanceLocation)) instanceof Collection) {
            toBeProcessed.keySet().removeAll((Collection)patternAnnotation);
        }
        boolean valid = true;
        for (JsonNode propNode : toBeProcessed.values()) {
            valid = ctx.resolveInternalRefAndValidate(this.schemaRef, propNode) && valid;
        }
        return valid ? Evaluator.Result.success(Collections.unmodifiableSet(toBeProcessed.keySet())) : Evaluator.Result.failure();
    }

    @Override
    public int getOrder() {
        return 10;
    }
}

