/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.List;

class ItemsEvaluator
implements Evaluator {
    private final CompoundUri schemaRef;

    ItemsEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getCompoundUri(node);
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return Evaluator.Result.success();
        }
        List<JsonNode> array = node.asArray();
        Object prefixItemsAnnotation = ctx.getSiblingAnnotation("prefixItems", node.getJsonPointer());
        int prefixItemsSize = prefixItemsAnnotation instanceof Integer ? (Integer)prefixItemsAnnotation : 0;
        boolean valid = true;
        for (int i = prefixItemsSize; i < array.size(); ++i) {
            valid = ctx.resolveInternalRefAndValidate(this.schemaRef, array.get(i)) && valid;
        }
        return valid ? Evaluator.Result.success(true) : Evaluator.Result.failure();
    }

    @Override
    public int getOrder() {
        return 10;
    }
}

