/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.SimpleType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public interface JsonNode {
    public static String encodeJsonPointer(String pointer) {
        return pointer.replace("~", "~0").replace("/", "~1");
    }

    public String getJsonPointer();

    public SimpleType getNodeType();

    default public boolean isNull() {
        return this.getNodeType() == SimpleType.NULL;
    }

    default public boolean isBoolean() {
        return this.getNodeType() == SimpleType.BOOLEAN;
    }

    default public boolean isString() {
        return this.getNodeType() == SimpleType.STRING;
    }

    default public boolean isInteger() {
        return this.getNodeType() == SimpleType.INTEGER;
    }

    default public boolean isNumber() {
        return this.getNodeType() == SimpleType.NUMBER || this.getNodeType() == SimpleType.INTEGER;
    }

    default public boolean isArray() {
        return this.getNodeType() == SimpleType.ARRAY;
    }

    default public boolean isObject() {
        return this.getNodeType() == SimpleType.OBJECT;
    }

    public boolean asBoolean();

    public String asString();

    public BigInteger asInteger();

    public BigDecimal asNumber();

    public List<JsonNode> asArray();

    public Map<String, JsonNode> asObject();

    default public String toPrintableString() {
        if (this.isObject()) {
            return "specific object";
        }
        if (this.isArray()) {
            return "specific array";
        }
        if (this.isInteger()) {
            return this.asInteger().toString();
        }
        return this.asString();
    }
}

