/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Dialect;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.EvaluatorWrapper;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeUtil;
import dev.harrel.jsonschema.Keyword;
import dev.harrel.jsonschema.MetaSchemaData;
import dev.harrel.jsonschema.MetaSchemaResolvingException;
import dev.harrel.jsonschema.MetaSchemaValidator;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SpecificationVersion;
import dev.harrel.jsonschema.UriUtil;
import dev.harrel.jsonschema.VocabularyValidator;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;

final class JsonParser {
    private final Map<URI, Dialect> dialects;
    private final Dialect defaultDialect;
    private final EvaluatorFactory evaluatorFactory;
    private final SchemaRegistry schemaRegistry;
    private final MetaSchemaValidator metaSchemaValidator;
    private final boolean disabledSchemaValidation;
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<URI, UnfinishedSchema> unfinishedSchemas = new HashMap<URI, UnfinishedSchema>();

    JsonParser(Map<URI, Dialect> dialects, Dialect defaultDialect, EvaluatorFactory evaluatorFactory, SchemaRegistry schemaRegistry, MetaSchemaValidator metaSchemaValidator, boolean disabledSchemaValidation) {
        this.dialects = Objects.requireNonNull(dialects);
        this.defaultDialect = Objects.requireNonNull(defaultDialect);
        this.evaluatorFactory = evaluatorFactory;
        this.schemaRegistry = Objects.requireNonNull(schemaRegistry);
        this.metaSchemaValidator = Objects.requireNonNull(metaSchemaValidator);
        this.disabledSchemaValidation = disabledSchemaValidation;
    }

    URI parseRootSchema(URI baseUri, JsonNode node) {
        this.lock.lock();
        try {
            SchemaRegistry.State snapshot = this.schemaRegistry.createSnapshot();
            try {
                URI uRI = this.parseRootSchemaInternal(UriUtil.getUriWithoutFragment(baseUri), node);
                return uRI;
            }
            catch (RuntimeException e) {
                this.schemaRegistry.restoreSnapshot(snapshot);
                throw e;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private URI parseRootSchemaInternal(URI baseUri, JsonNode node) {
        Optional<Map<String, JsonNode>> objectMapOptional = JsonNodeUtil.getAsObject(node);
        URI metaSchemaUri = Optional.ofNullable(objectMapOptional.flatMap(obj -> JsonNodeUtil.getStringField(obj, "$schema")).orElseGet(this.defaultDialect::getMetaSchema)).map(UriUtil::removeEmptyFragment).orElse(null);
        Optional<URI> idField = objectMapOptional.flatMap(obj -> JsonNodeUtil.getStringField(obj, "$id"));
        Optional<URI> providedSchemaId = idField.map(UriUtil::getUriWithoutFragment).filter(id -> !baseUri.equals(id));
        UnfinishedSchema unfinishedSchema = new UnfinishedSchema();
        this.unfinishedSchemas.put(baseUri, unfinishedSchema);
        providedSchemaId.ifPresent(id -> this.unfinishedSchemas.put((URI)id, unfinishedSchema));
        SpecificationVersion specVersion = this.resolveSpecVersion(metaSchemaUri);
        if (specVersion.getOrder() <= SpecificationVersion.DRAFT4.getOrder()) {
            providedSchemaId.ifPresent(this.unfinishedSchemas::remove);
            idField = objectMapOptional.flatMap(obj -> JsonNodeUtil.getStringField(obj, "id"));
            providedSchemaId = idField.map(UriUtil::getUriWithoutFragment).filter(id -> !baseUri.equals(id));
            providedSchemaId.ifPresent(id -> this.unfinishedSchemas.put((URI)id, unfinishedSchema));
        }
        URI finalUri = providedSchemaId.orElse(baseUri);
        MetaSchemaData metaSchemaData = this.validateAgainstMetaSchema(node, metaSchemaUri, finalUri.toString());
        if (node.isBoolean()) {
            SchemaParsingContext ctx = new SchemaParsingContext(metaSchemaData, baseUri, this.schemaRegistry, Collections.emptyMap());
            List<EvaluatorWrapper> evaluators = Collections.singletonList(new EvaluatorWrapper(null, node, Schema.getBooleanEvaluator(node.asBoolean())));
            this.schemaRegistry.registerSchema(ctx, node, evaluators);
        } else if (objectMapOptional.isPresent()) {
            Map<String, JsonNode> objectMap = objectMapOptional.get();
            SchemaParsingContext ctx = new SchemaParsingContext(metaSchemaData, finalUri, this.schemaRegistry, objectMap);
            idField.ifPresent(id -> JsonParser.validateIdField(ctx, id));
            List<EvaluatorWrapper> evaluators = this.parseEvaluators(ctx, objectMap, node.getJsonPointer());
            this.schemaRegistry.registerSchema(ctx, node, evaluators);
            providedSchemaId.ifPresent(id -> this.schemaRegistry.registerAlias((URI)id, baseUri));
        }
        unfinishedSchema.parsed();
        this.unfinishedSchemas.remove(baseUri);
        providedSchemaId.ifPresent(this.unfinishedSchemas::remove);
        return finalUri;
    }

    private void parseNode(SchemaParsingContext ctx, JsonNode node) {
        if (node.isBoolean()) {
            this.parseBoolean(ctx, node);
        } else if (node.isArray()) {
            this.parseArray(ctx, node);
        } else if (node.isObject()) {
            this.parseObject(ctx, node);
        }
    }

    private void parseBoolean(SchemaParsingContext ctx, JsonNode node) {
        Evaluator booleanEvaluator = Schema.getBooleanEvaluator(node.asBoolean());
        List<EvaluatorWrapper> evaluators = Collections.singletonList(new EvaluatorWrapper(null, node, booleanEvaluator));
        this.schemaRegistry.registerSchema(ctx, node, evaluators);
    }

    private void parseArray(SchemaParsingContext ctx, JsonNode node) {
        for (JsonNode element : node.asArray()) {
            this.parseNode(ctx, element);
        }
    }

    private void parseObject(SchemaParsingContext ctx, JsonNode node) {
        Map<String, JsonNode> objectMap = node.asObject();
        SpecificationVersion specVersion = JsonNodeUtil.getStringField(objectMap, "$schema").map(UriUtil::removeEmptyFragment).map(this.dialects::get).map(Dialect::getSpecificationVersion).orElse(ctx.getMetaValidationData().dialect.getSpecificationVersion());
        Optional<String> idField = JsonNodeUtil.getStringField(objectMap, Keyword.getIdKeyword(specVersion));
        boolean isEmbeddedSchema = idField.map(id -> !id.startsWith("#") || specVersion.getOrder() > SpecificationVersion.DRAFT7.getOrder()).orElse(false);
        if (!isEmbeddedSchema) {
            SchemaParsingContext newCtx = ctx.forChild(objectMap);
            this.schemaRegistry.registerSchema(ctx, node, this.parseEvaluators(newCtx, objectMap, node.getJsonPointer()));
        } else {
            String idString = idField.get();
            URI idUri = URI.create(idString);
            UnfinishedSchema unfinishedSchema = new UnfinishedSchema();
            this.unfinishedSchemas.put(idUri, unfinishedSchema);
            MetaSchemaData metaSchemaData = JsonNodeUtil.getStringField(objectMap, "$schema").map(UriUtil::removeEmptyFragment).map(metaSchemaUri -> this.validateAgainstMetaSchema(node, (URI)metaSchemaUri, idUri.toString())).orElse(ctx.getMetaValidationData());
            URI uri = ctx.getParentUri().resolve(idUri);
            SchemaParsingContext newCtx = ctx.forChild(metaSchemaData, objectMap, uri);
            JsonParser.validateIdField(newCtx, idString);
            List<EvaluatorWrapper> evaluators = this.parseEvaluators(newCtx, objectMap, node.getJsonPointer());
            this.schemaRegistry.registerEmbeddedSchema(newCtx, uri, node, evaluators);
            unfinishedSchema.parsed();
            this.unfinishedSchemas.remove(idUri);
        }
    }

    private List<EvaluatorWrapper> parseEvaluators(SchemaParsingContext ctx, Map<String, JsonNode> object, String objectPath) {
        ArrayList<EvaluatorWrapper> evaluators = new ArrayList<EvaluatorWrapper>();
        JsonNode refOverride = null;
        if (ctx.getSpecificationVersion().getOrder() <= SpecificationVersion.DRAFT7.getOrder()) {
            refOverride = object.get("$ref");
        }
        for (Map.Entry<String, JsonNode> entry : object.entrySet()) {
            block7: {
                block6: {
                    if (refOverride == null) break block6;
                    if (entry.getValue() != refOverride) break block7;
                }
                this.createEvaluatorFactory(ctx).create(ctx, entry.getKey(), entry.getValue()).map(evaluator -> new EvaluatorWrapper((String)entry.getKey(), (JsonNode)entry.getValue(), (Evaluator)evaluator)).ifPresent(evaluators::add);
            }
            this.parseNode(ctx, entry.getValue());
        }
        if (evaluators.isEmpty()) {
            evaluators.add(new EvaluatorWrapper(null, objectPath, Schema.getBooleanEvaluator(true)));
        }
        return evaluators;
    }

    private MetaSchemaData validateAgainstMetaSchema(JsonNode node, URI metaSchemaUri, String uri) {
        MetaSchemaData data = this.resolveMetaSchemaData(node, metaSchemaUri, uri);
        new VocabularyValidator().validateVocabularies(data.dialect, data.vocabularyObject);
        return data;
    }

    private SpecificationVersion resolveSpecVersion(URI metaSchemaUri) {
        if (metaSchemaUri == null) {
            return this.defaultDialect.getSpecificationVersion();
        }
        Dialect dialect = this.dialects.get(metaSchemaUri);
        if (dialect == null) {
            if (this.disabledSchemaValidation) {
                dialect = this.defaultDialect;
            } else {
                if (this.unfinishedSchemas.containsKey(metaSchemaUri)) {
                    throw MetaSchemaResolvingException.recursiveFailure(metaSchemaUri.toString());
                }
                dialect = this.metaSchemaValidator.resolveMetaSchema((JsonParser)this, (URI)metaSchemaUri).getMetaValidationData().dialect;
            }
        }
        return dialect.getSpecificationVersion();
    }

    private MetaSchemaData resolveMetaSchemaData(JsonNode node, URI metaSchemaUri, String uri) {
        if (this.disabledSchemaValidation) {
            return new MetaSchemaData(this.dialects.getOrDefault(metaSchemaUri, this.defaultDialect));
        }
        Dialect dialect = this.dialects.get(metaSchemaUri);
        UnfinishedSchema unfinishedSchema = this.unfinishedSchemas.get(metaSchemaUri);
        if (unfinishedSchema != null) {
            if (dialect == null) {
                throw MetaSchemaResolvingException.recursiveFailure(metaSchemaUri.toString());
            }
            unfinishedSchema.callbacks.add(() -> this.metaSchemaValidator.validateSchema(this, metaSchemaUri, uri, node));
            return new MetaSchemaData(dialect);
        }
        MetaSchemaData metaSchemaData = this.metaSchemaValidator.validateSchema(this, metaSchemaUri, uri, node);
        if (dialect == null) {
            return metaSchemaData;
        }
        if (metaSchemaData.vocabularyObject == null) {
            return new MetaSchemaData(dialect, dialect.getDefaultVocabularyObject(), dialect.getDefaultVocabularyObject().keySet());
        }
        return new MetaSchemaData(dialect, metaSchemaData.vocabularyObject, metaSchemaData.activeVocabularies);
    }

    private EvaluatorFactory createEvaluatorFactory(SchemaParsingContext ctx) {
        if (this.evaluatorFactory != null) {
            return EvaluatorFactory.compose(this.evaluatorFactory, ctx.getMetaValidationData().dialect.getEvaluatorFactory());
        }
        return ctx.getMetaValidationData().dialect.getEvaluatorFactory();
    }

    private static void validateIdField(SchemaParsingContext ctx, String id) {
        URI uri = URI.create(id);
        if (ctx.getSpecificationVersion().getOrder() > SpecificationVersion.DRAFT7.getOrder()) {
            if (uri.getRawFragment() != null && !uri.getRawFragment().isEmpty()) {
                throw new IllegalArgumentException(String.format("$id [%s] cannot contain non-empty fragments", id));
            }
        } else if (uri.getRawFragment() != null && uri.getRawFragment().startsWith("/")) {
            throw new IllegalArgumentException(String.format("$id [%s] cannot contain fragments starting with '/'", id));
        }
    }

    private static final class UnfinishedSchema {
        private final List<Runnable> callbacks = new ArrayList<Runnable>();

        private UnfinishedSchema() {
        }

        void parsed() {
            for (int i = 0; i < this.callbacks.size(); ++i) {
                this.callbacks.get(i).run();
            }
        }
    }
}

