/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;

final class MapEvaluatorFactory
implements EvaluatorFactory {
    private final Map<String, BiFunction<SchemaParsingContext, JsonNode, Evaluator>> providers;

    MapEvaluatorFactory(Map<String, BiFunction<SchemaParsingContext, JsonNode, Evaluator>> providers) {
        this.providers = Collections.unmodifiableMap(new HashMap<String, BiFunction<SchemaParsingContext, JsonNode, Evaluator>>(providers));
    }

    @Override
    public Optional<Evaluator> create(SchemaParsingContext ctx, String fieldName, JsonNode fieldNode) {
        BiFunction<SchemaParsingContext, JsonNode, Evaluator> provider = this.providers.get(fieldName);
        if (provider == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(provider.apply(ctx, fieldNode));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

