/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluatorWrapper;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeUtil;
import dev.harrel.jsonschema.Keyword;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.SpecificationVersion;
import dev.harrel.jsonschema.UriUtil;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

final class SchemaRegistry {
    private volatile State state = State.access$000();

    SchemaRegistry() {
    }

    State createSnapshot() {
        return this.state.copy();
    }

    void restoreSnapshot(State state) {
        this.state = state;
    }

    Schema get(URI baseUri) {
        return this.get(new CompoundUri(baseUri, ""));
    }

    Schema get(CompoundUri compoundUri) {
        Fragments fragments = this.state.getFragments(compoundUri.uri);
        if (fragments == null) {
            return null;
        }
        Schema schema = (Schema)fragments.schemas.get(compoundUri.fragment);
        if (schema != null) {
            return schema;
        }
        return (Schema)fragments.additionalSchemas.get(compoundUri.fragment);
    }

    Schema getDynamic(URI baseUri) {
        return this.getDynamic(new CompoundUri(baseUri, ""));
    }

    Schema getDynamic(CompoundUri compoundUri) {
        Fragments fragments = this.state.getFragments(compoundUri.uri);
        if (fragments == null) {
            return null;
        }
        return (Schema)fragments.dynamicSchemas.get(compoundUri.fragment);
    }

    void registerAlias(URI originalUri, URI aliasUri) {
        Fragments originalFragments = this.state.createIfAbsent(originalUri);
        this.state.fragments.put(aliasUri, originalFragments.readOnly());
    }

    void registerSchema(SchemaParsingContext ctx, JsonNode schemaNode, List<EvaluatorWrapper> evaluators) {
        Schema schema = new Schema(ctx.getParentUri(), ctx.getAbsoluteUri(schemaNode), evaluators, ctx.getMetaValidationData(), ctx.getCurrentSchemaObject());
        this.state.createIfAbsent(ctx.getBaseUri()).schemas.put(schemaNode.getJsonPointer(), schema);
        this.registerAnchorsIfPresent(ctx, schemaNode, schema);
    }

    void registerEmbeddedSchema(SchemaParsingContext ctx, URI id, JsonNode schemaNode, List<EvaluatorWrapper> evaluators) {
        Fragments baseFragments = this.state.createIfAbsent(ctx.getBaseUri());
        Fragments idFragments = this.state.createIfAbsent(UriUtil.getUriWithoutFragment(id));
        baseFragments.schemas.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(schemaNode.getJsonPointer())).forEach(e -> {
            String newJsonPointer = ((String)e.getKey()).substring(schemaNode.getJsonPointer().length());
            idFragments.additionalSchemas.put(newJsonPointer, (Schema)e.getValue());
        });
        Schema identifiableSchema = new Schema(ctx.getParentUri(), ctx.getAbsoluteUri(schemaNode), evaluators, ctx.getMetaValidationData(), ctx.getCurrentSchemaObject());
        idFragments.schemas.put("", identifiableSchema);
        baseFragments.schemas.put(schemaNode.getJsonPointer(), identifiableSchema);
        this.registerAnchorsIfPresent(ctx, schemaNode, identifiableSchema);
    }

    private void registerAnchorsIfPresent(SchemaParsingContext ctx, JsonNode schemaNode, Schema schema) {
        if (!schemaNode.isObject()) {
            return;
        }
        Map<String, JsonNode> objectMap = schemaNode.asObject();
        Fragments fragments = this.state.createIfAbsent(ctx.getParentUri());
        if (ctx.getSpecificationVersion().getOrder() > SpecificationVersion.DRAFT7.getOrder()) {
            JsonNodeUtil.getStringField(objectMap, "$anchor").ifPresent(anchorString -> fragments.additionalSchemas.put(anchorString, schema));
            if (ctx.getSpecificationVersion() == SpecificationVersion.DRAFT2019_09) {
                JsonNodeUtil.getBooleanField(objectMap, "$recursiveAnchor").filter(anchor -> anchor).ifPresent(anchorString -> fragments.dynamicSchemas.put("", schema));
            } else {
                JsonNodeUtil.getStringField(objectMap, "$dynamicAnchor").ifPresent(anchorString -> fragments.dynamicSchemas.put(anchorString, schema));
            }
        } else {
            JsonNodeUtil.getStringField(objectMap, Keyword.getIdKeyword(ctx.getSpecificationVersion())).map(URI::create).map(URI::getFragment).ifPresent(anchorString -> fragments.additionalSchemas.put(anchorString, schema));
        }
    }

    static final class State {
        private final Map<URI, Fragments> fragments;

        private State(Map<URI, Fragments> fragments) {
            this.fragments = fragments;
        }

        private Fragments getFragments(URI uri) {
            return this.fragments.get(uri);
        }

        private Fragments createIfAbsent(URI uri) {
            return this.fragments.computeIfAbsent(uri, key -> Fragments.empty());
        }

        private State copy() {
            Map copiedMap = this.fragments.entrySet().stream().collect(Collectors.toConcurrentMap(Map.Entry::getKey, e -> ((Fragments)e.getValue()).copy()));
            return new State(copiedMap);
        }

        private static State empty() {
            return new State(new ConcurrentHashMap<URI, Fragments>());
        }

        static /* synthetic */ State access$000() {
            return State.empty();
        }
    }

    private static final class Fragments {
        private final Map<String, Schema> schemas;
        private final Map<String, Schema> additionalSchemas;
        private final Map<String, Schema> dynamicSchemas;

        private Fragments(Map<String, Schema> schemas, Map<String, Schema> additionalSchemas, Map<String, Schema> dynamicSchemas) {
            this.schemas = schemas;
            this.additionalSchemas = additionalSchemas;
            this.dynamicSchemas = dynamicSchemas;
        }

        private Fragments copy() {
            return new Fragments(new ConcurrentHashMap<String, Schema>(this.schemas), new ConcurrentHashMap<String, Schema>(this.additionalSchemas), new ConcurrentHashMap<String, Schema>(this.dynamicSchemas));
        }

        private Fragments readOnly() {
            return new Fragments(Collections.unmodifiableMap(this.schemas), Collections.unmodifiableMap(this.additionalSchemas), Collections.unmodifiableMap(this.dynamicSchemas));
        }

        private static Fragments empty() {
            return new Fragments(new ConcurrentHashMap<String, Schema>(), new ConcurrentHashMap<String, Schema>(), new ConcurrentHashMap<String, Schema>());
        }
    }
}

