/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.UriUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public enum SpecificationVersion {
    DRAFT2020_12(9, "https://json-schema.org/draft/2020-12/schema", "/draft2020-12.json", Collections.emptyList()),
    DRAFT2019_09(8, "https://json-schema.org/draft/2019-09/schema", "/dev/harrel/jsonschema/draft/2019-09/schema.json", Arrays.asList("meta/applicator", "meta/content", "meta/core", "meta/format", "meta/meta-data", "meta/validation")),
    DRAFT7(7, "http://json-schema.org/draft-07/schema#", "/dev/harrel/jsonschema/draft-07/schema.json", Collections.emptyList()),
    DRAFT6(6, "http://json-schema.org/draft-06/schema#", "/dev/harrel/jsonschema/draft-06/schema.json", Collections.emptyList()),
    DRAFT4(4, "http://json-schema.org/draft-04/schema#", "/dev/harrel/jsonschema/draft-04/schema.json", Collections.emptyList());

    private final int order;
    private final URI id;
    private final URI resourcePath;
    private final Map<URI, URI> additionalResources;

    private SpecificationVersion(int order, String id, String resourcePath, List<String> additionalPaths) {
        this.order = order;
        this.id = URI.create(id);
        this.resourcePath = URI.create(resourcePath);
        HashMap<URI, URI> resourceMap = new HashMap<URI, URI>();
        resourceMap.put(UriUtil.getUriWithoutFragment(this.id), SpecificationVersion.getLastPathSegmentWithoutExtension(this.resourcePath));
        for (String additionalPath : additionalPaths) {
            URI additionalUri = URI.create(additionalPath);
            resourceMap.put(this.id.resolve(additionalPath), additionalUri);
        }
        this.additionalResources = Collections.unmodifiableMap(resourceMap);
    }

    Optional<String> resolveResource(URI uri) {
        URI normalizedUri = UriUtil.getUriWithoutFragment(uri);
        URI relativePath = this.additionalResources.get(normalizedUri);
        if (relativePath == null) {
            return Optional.empty();
        }
        return SpecificationVersion.readFileResource(this.resourcePath.resolve(relativePath) + ".json");
    }

    public String getId() {
        return this.id.toString();
    }

    public String getResourcePath() {
        return this.resourcePath.toString();
    }

    int getOrder() {
        return this.order;
    }

    private static URI getLastPathSegmentWithoutExtension(URI uri) {
        int start = uri.getPath().lastIndexOf(47);
        int end = uri.getPath().lastIndexOf(46);
        return URI.create(uri.getPath().substring(start + 1, end));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> readFileResource(String uri) {
        try (InputStream is = SpecificationVersion.class.getResourceAsStream(uri);){
            if (is == null) {
                Optional<String> optional2 = Optional.empty();
                return optional2;
            }
            Optional<String> optional = Optional.of(new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining()));
            return optional;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

