/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.generator;

import dev.hilla.generator.GenerationOutputDirectory;
import io.swagger.codegen.v3.auth.AuthParser;
import io.swagger.codegen.v3.config.CodegenConfigurator;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.util.List;

class OpenAPIParser {
    private static final String CLIENT_PATH_TEMPLATE_PROPERTY = "vaadinConnectDefaultClientPath";
    private final CodegenConfigurator configurator = new CodegenConfigurator();

    OpenAPIParser(File openApiJsonFile, GenerationOutputDirectory outputDirectory, Class<?> language) {
        this(openApiJsonFile, outputDirectory, language, null);
    }

    OpenAPIParser(File openApiJsonFile, GenerationOutputDirectory outputDirectory, Class<?> language, String defaultClientPath) {
        this.configurator.setLang(language.getName());
        this.configurator.setInputSpecURL(openApiJsonFile.toString());
        this.configurator.setOutputDir(outputDirectory.toString());
        this.configurator.addAdditionalProperty(CLIENT_PATH_TEMPLATE_PROPERTY, (Object)OpenAPIParser.getDefaultClientPath(defaultClientPath));
    }

    private static String getDefaultClientPath(String path) {
        path = path != null ? path : "./connect-client.default";
        return path.endsWith(".ts") ? path.substring(0, path.length() - ".ts".length()) : path;
    }

    CodegenConfigurator getConfigurator() {
        return this.configurator;
    }

    OpenAPI parseOpenAPI() {
        SwaggerParseResult result;
        try {
            List authorizationValues = AuthParser.parse((String)this.configurator.getAuth());
            String inputSpec = this.configurator.loadSpecContent(this.configurator.getInputSpecURL(), authorizationValues);
            ParseOptions options = new ParseOptions();
            options.setResolve(true);
            result = new io.swagger.parser.OpenAPIParser().readContents(inputSpec, authorizationValues, options);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't read file '%s'", this.configurator.getInputSpecURL()), e);
        }
        if (result == null || !result.getMessages().isEmpty()) {
            String error = result == null ? "" : String.join((CharSequence)"", result.getMessages());
            throw new IllegalStateException("Unexpected error while generating Vaadin TypeScript endpoint wrappers. The input file " + this.configurator.getInputSpecURL() + " might be corrupted, please try running the generating tasks again. " + error);
        }
        OpenAPI openAPI = result.getOpenAPI();
        if (openAPI.getComponents() == null) {
            openAPI.setComponents(new Components());
        }
        return openAPI;
    }
}

