/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.push;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.hilla.push.PushMessageHandler;
import dev.hilla.push.messages.fromclient.AbstractServerMessage;
import dev.hilla.push.messages.toclient.AbstractClientMessage;
import java.io.IOException;
import java.security.Principal;
import java.util.function.Consumer;
import javax.servlet.ServletContext;
import org.atmosphere.client.TrackMessageSizeInterceptor;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.config.service.Singleton;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.handler.AtmosphereHandlerAdapter;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.atmosphere.interceptor.SuspendTrackerInterceptor;
import org.atmosphere.util.IOUtils;
import org.atmosphere.util.SimpleBroadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@AtmosphereHandlerService(path="/HILLA/push", broadcaster=SimpleBroadcaster.class, interceptors={AtmosphereResourceLifecycleInterceptor.class, TrackMessageSizeInterceptor.class, SuspendTrackerInterceptor.class})
@Singleton
public class PushEndpoint
extends AtmosphereHandlerAdapter {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private PushMessageHandler pushMessageHandler;

    private void autowire(ServletContext servletContext) {
        WebApplicationContext ac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        ac.getAutowireCapableBeanFactory().autowireBean((Object)this);
    }

    public void onRequest(AtmosphereResource resource) throws IOException {
        String method;
        if (this.objectMapper == null) {
            this.autowire(resource.getAtmosphereConfig().getServletContext());
        }
        if ((method = resource.getRequest().getMethod()).equalsIgnoreCase("GET")) {
            this.onConnect(resource);
        } else if (method.equalsIgnoreCase("POST")) {
            this.onMessageRequest(resource);
        }
        super.onRequest(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMessageRequest(AtmosphereResource resource) {
        block6: {
            AtmosphereRequest request = resource.getRequest();
            try {
                String message;
                Object o = IOUtils.readEntirely((AtmosphereResource)resource);
                if (IOUtils.isBodyEmpty((Object)o)) {
                    this.getLogger().warn("Received an empty body for push message {}", (Object)request);
                    return;
                }
                String string = message = o == null ? null : o.toString();
                if (message == null) break block6;
                Principal p = request.getUserPrincipal();
                SecurityContextHolder.setContext((SecurityContext)new SecurityContextImpl((Authentication)p));
                try {
                    this.onMessage(resource, message);
                }
                finally {
                    SecurityContextHolder.clearContext();
                }
            }
            catch (IOException e) {
                this.getLogger().warn("Unable to read push message {}", (Object)request, (Object)e);
                return;
            }
        }
    }

    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        super.onStateChange(event);
        if (event.isCancelled() || event.isResumedOnTimeout()) {
            this.onDisconnect(event);
        }
    }

    private void onMessage(AtmosphereResource resource, String messageFromClient) {
        try {
            AbstractServerMessage message = (AbstractServerMessage)this.objectMapper.readValue(messageFromClient, AbstractServerMessage.class);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Received push message from the client: " + message);
            }
            Consumer<AbstractClientMessage> sender = msg -> {
                try {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Sending push message to the client: " + msg);
                    }
                    resource.write(this.objectMapper.writeValueAsString(msg));
                }
                catch (JsonProcessingException | IllegalArgumentException e1) {
                    this.getLogger().warn("Unexpected problem when sending push message", e1);
                }
            };
            this.pushMessageHandler.handleMessage(resource.uuid(), message, sender);
        }
        catch (JsonProcessingException e) {
            this.getLogger().warn("Unexpected problem when receiving push message", (Throwable)e);
        }
    }

    private void onConnect(AtmosphereResource resource) {
        this.pushMessageHandler.handleBrowserConnect(resource.uuid());
        resource.addEventListener((AtmosphereResourceEventListener)new DisconnectListener(this));
    }

    private void onDisconnect(AtmosphereResourceEvent event) {
        this.pushMessageHandler.handleBrowserDisconnect(event.getResource().uuid());
    }

    private void onThrowable(AtmosphereResourceEvent event) {
        this.getLogger().error("Exception in push connection", event.throwable());
        this.onDisconnect(event);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    private static class DisconnectListener
    extends AtmosphereResourceEventListenerAdapter {
        private PushEndpoint pushEndpoint;

        public DisconnectListener(PushEndpoint pushEndpoint) {
            this.pushEndpoint = pushEndpoint;
        }

        public void onDisconnect(AtmosphereResourceEvent event) {
            super.onDisconnect(event);
            this.pushEndpoint.onDisconnect(event);
        }

        public void onThrowable(AtmosphereResourceEvent event) {
            super.onThrowable(event);
            this.pushEndpoint.onThrowable(event);
        }
    }
}

