/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla;

import com.github.javaparser.ast.expr.AnnotationExpr;
import dev.hilla.ExplicitNullableTypeCheckerHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Stream;

public class ExplicitNullableTypeChecker {
    private static final String NULLABLE_ANNOTATION_NAME = "nullable";
    private static final String NONNULL_ANNOTATION_NAME = "nonnull";

    public static boolean isRequired(AnnotatedElement element, boolean requiredByContext) {
        if (element instanceof Field && ((Field)element).getType().isPrimitive() || element instanceof Parameter && ((Parameter)element).getType().isPrimitive()) {
            return true;
        }
        Stream<Annotation> annotations = Stream.of(element.getAnnotations());
        if (element instanceof Field) {
            annotations = Stream.concat(annotations, Stream.of(((Field)element).getAnnotatedType().getAnnotations()));
        } else if (element instanceof Parameter) {
            annotations = Stream.concat(annotations, Stream.of(((Parameter)element).getAnnotatedType().getAnnotations()));
        }
        if (requiredByContext) {
            return !ExplicitNullableTypeChecker.hasAnnotation(annotations, NULLABLE_ANNOTATION_NAME);
        }
        return ExplicitNullableTypeChecker.hasAnnotation(annotations, NONNULL_ANNOTATION_NAME);
    }

    public static boolean isRequired(boolean requiredByContext, List<AnnotationExpr> annotations) {
        if (requiredByContext) {
            return !ExplicitNullableTypeChecker.hasAnnotation(annotations, NULLABLE_ANNOTATION_NAME);
        }
        return ExplicitNullableTypeChecker.hasAnnotation(annotations, NONNULL_ANNOTATION_NAME);
    }

    private static boolean hasAnnotation(List<AnnotationExpr> annotations, String annotationName) {
        return annotations != null && annotations.stream().anyMatch(annotation -> annotationName.equalsIgnoreCase(annotation.getName().getIdentifier()));
    }

    private static boolean hasAnnotation(Stream<Annotation> annotations, String annotationName) {
        return annotations.anyMatch(annotation -> annotationName.equalsIgnoreCase(annotation.annotationType().getSimpleName()));
    }

    public String checkValueForAnnotatedElement(Object value, AnnotatedElement annotatedElement, boolean requiredByContext) {
        if (!ExplicitNullableTypeChecker.isRequired(annotatedElement, requiredByContext)) {
            return null;
        }
        if (annotatedElement instanceof Method) {
            return this.checkValueForType(value, ((Method)annotatedElement).getGenericReturnType(), requiredByContext);
        }
        return null;
    }

    String checkValueForType(Object value, Type expectedType, boolean requiredByContext) {
        return new ExplicitNullableTypeCheckerHelper(requiredByContext).checkValueForType(value, expectedType);
    }
}

