/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import dev.hilla.Endpoint;
import dev.hilla.EndpointControllerConfiguration;
import dev.hilla.EndpointInvocationException;
import dev.hilla.EndpointInvoker;
import dev.hilla.EndpointProperties;
import dev.hilla.EndpointRegistry;
import dev.hilla.auth.CsrfChecker;
import dev.hilla.exception.EndpointException;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Import(value={EndpointControllerConfiguration.class, EndpointProperties.class})
@NpmPackage.Container(value={@NpmPackage(value="@hilla/frontend", version="2.0.0"), @NpmPackage(value="@hilla/form", version="2.0.0")})
public class EndpointController {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointController.class);
    static final String ENDPOINT_METHODS = "/{endpoint}/{method}";
    public static final String ENDPOINT_MAPPER_FACTORY_BEAN_QUALIFIER = "endpointMapperFactory";
    private final ApplicationContext context;
    EndpointRegistry endpointRegistry;
    private final CsrfChecker csrfChecker;
    private final EndpointInvoker endpointInvoker;
    private String openApiResourceName = "/dev/hilla/openapi.json";

    public EndpointController(ApplicationContext context, EndpointRegistry endpointRegistry, EndpointInvoker endpointInvoker, CsrfChecker csrfChecker) {
        this.context = context;
        this.endpointInvoker = endpointInvoker;
        this.csrfChecker = csrfChecker;
        this.endpointRegistry = endpointRegistry;
    }

    void setOpenApiResourceName(String openApiResourceName) {
        this.openApiResourceName = openApiResourceName;
    }

    @PostConstruct
    public void registerEndpoints() {
        TreeMap<String, Object> endpointBeans = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        endpointBeans.putAll(this.context.getBeansWithAnnotation(Endpoint.class));
        this.registerEndpointsFromApiDefinition(endpointBeans);
        if (this.endpointRegistry.isEmpty() && !endpointBeans.isEmpty()) {
            LOGGER.debug("No endpoints found in openapi.json: registering all endpoints found using the Spring context");
            endpointBeans.forEach((name, endpointBean) -> this.endpointRegistry.registerEndpoint(endpointBean));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(path={"/{endpoint}/{method}"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> serveEndpoint(@PathVariable(value="endpoint") String endpointName, @PathVariable(value="method") String methodName, @RequestBody(required=false) ObjectNode body, HttpServletRequest request) {
        LOGGER.debug("Endpoint: {}, method: {}, request body: {}", new Object[]{endpointName, methodName, body});
        if (!this.csrfChecker.validateCsrfTokenInRequest(request)) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)this.endpointInvoker.createResponseErrorObject("Access denied"));
        }
        try {
            VaadinServletService service = (VaadinServletService)VaadinService.getCurrent();
            CurrentInstance.set(VaadinRequest.class, (Object)new VaadinServletRequest(request, service));
            Object returnValue = this.endpointInvoker.invoke(endpointName, methodName, body, request.getUserPrincipal(), arg_0 -> ((HttpServletRequest)request).isUserInRole(arg_0));
            try {
                ResponseEntity responseEntity = ResponseEntity.ok((Object)this.endpointInvoker.writeValueAsString(returnValue));
                return responseEntity;
            }
            catch (JsonProcessingException e) {
                ResponseEntity responseEntity;
                try {
                    String errorMessage = String.format("Failed to serialize endpoint '%s' method '%s' response. Double check method's return type or specify a custom mapper bean with qualifier '%s'", endpointName, methodName, ENDPOINT_MAPPER_FACTORY_BEAN_QUALIFIER);
                    LOGGER.error(errorMessage, (Throwable)e);
                    throw new EndpointInvocationException.EndpointInternalException(errorMessage);
                }
                catch (EndpointException e2) {
                    try {
                        returnValue = ResponseEntity.badRequest().body((Object)this.endpointInvoker.createResponseErrorObject(e2.getSerializationData()));
                        return returnValue;
                    }
                    catch (JsonProcessingException ee) {
                        String errorMessage = String.format("Failed to serialize error object for endpoint exception. ", new Object[0]);
                        LOGGER.error(errorMessage, (Throwable)e2);
                        ResponseEntity responseEntity2 = ResponseEntity.internalServerError().body((Object)errorMessage);
                        return responseEntity2;
                    }
                }
                catch (EndpointInvocationException.EndpointNotFoundException e3) {
                    responseEntity = ResponseEntity.notFound().build();
                    return responseEntity;
                }
                catch (EndpointInvocationException.EndpointAccessDeniedException e4) {
                    responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)this.endpointInvoker.createResponseErrorObject(e4.getMessage()));
                    return responseEntity;
                }
                catch (EndpointInvocationException.EndpointBadRequestException e5) {
                    responseEntity = ResponseEntity.badRequest().body((Object)this.endpointInvoker.createResponseErrorObject(e5.getMessage()));
                    return responseEntity;
                }
                catch (EndpointInvocationException.EndpointInternalException e6) {
                    responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.endpointInvoker.createResponseErrorObject(e6.getMessage()));
                    return responseEntity;
                }
            }
        }
        finally {
            CurrentInstance.set(VaadinRequest.class, null);
        }
    }

    private void registerEndpointsFromApiDefinition(Map<String, Object> knownEndpointBeans) {
        URL resource = this.getClass().getResource(this.openApiResourceName);
        if (resource == null) {
            LOGGER.error("Resource '{}' is not available", (Object)this.openApiResourceName);
        } else {
            try (InputStream stream = resource.openStream();){
                JsonNode rootNode = new ObjectMapper().readTree(stream);
                ArrayNode tagsNode = (ArrayNode)rootNode.get("tags");
                if (tagsNode != null) {
                    tagsNode.forEach(tag -> Optional.ofNullable(tag.get("name")).map(JsonNode::asText).map(knownEndpointBeans::get).or(() -> Optional.ofNullable(tag.get("x-class-name")).map(JsonNode::asText).map(this::instantiateEndpointByClassName)).ifPresent(this.endpointRegistry::registerEndpoint));
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to read openapi.json", (Throwable)e);
            }
        }
    }

    private Object instantiateEndpointByClassName(String className) {
        Class<?> cls;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Endpoint class {} is not available", (Object)className, (Object)e);
            return null;
        }
        try {
            return cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            LOGGER.error("Failed to create endpoint instance for class '{}': if an endpoint is not a Spring bean, it must have a default constructor", (Object)className);
        }
        catch (ReflectiveOperationException ex) {
            LOGGER.warn("Failed to create endpoint instance for class '{}'", (Object)className, (Object)ex);
        }
        return null;
    }
}

