/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.server.VaadinServletContext;
import dev.hilla.EndpointInvocationException;
import dev.hilla.EndpointRegistry;
import dev.hilla.ExplicitNullableTypeChecker;
import dev.hilla.auth.EndpointAccessChecker;
import dev.hilla.endpointransfermapper.EndpointTransferMapper;
import dev.hilla.exception.EndpointException;
import dev.hilla.exception.EndpointValidationException;
import dev.hilla.parser.jackson.JacksonObjectMapperFactory;
import jakarta.servlet.ServletContext;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.lang.NonNullApi;
import org.springframework.util.ClassUtils;

public class EndpointInvoker {
    private static final EndpointTransferMapper endpointTransferMapper = new EndpointTransferMapper();
    private final ApplicationContext applicationContext;
    private final ObjectMapper endpointMapper;
    private final EndpointRegistry endpointRegistry;
    private final ExplicitNullableTypeChecker explicitNullableTypeChecker;
    private final ServletContext servletContext;
    private final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    public EndpointInvoker(ApplicationContext applicationContext, JacksonObjectMapperFactory endpointMapperFactory, ExplicitNullableTypeChecker explicitNullableTypeChecker, ServletContext servletContext, EndpointRegistry endpointRegistry) {
        this.applicationContext = applicationContext;
        this.servletContext = servletContext;
        ObjectMapper objectMapper = this.endpointMapper = endpointMapperFactory != null ? endpointMapperFactory.build() : EndpointInvoker.createDefaultEndpointMapper(applicationContext);
        if (this.endpointMapper != null) {
            this.endpointMapper.registerModule(endpointTransferMapper.getJacksonModule());
        }
        this.explicitNullableTypeChecker = explicitNullableTypeChecker;
        this.endpointRegistry = endpointRegistry;
    }

    private static ObjectMapper createDefaultEndpointMapper(ApplicationContext applicationContext) {
        ObjectMapper endpointMapper = new JacksonObjectMapperFactory.Json().build();
        ((Jackson2ObjectMapperBuilder)applicationContext.getBean(Jackson2ObjectMapperBuilder.class)).configure(endpointMapper);
        return endpointMapper;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(EndpointInvoker.class);
    }

    public Class<?> getReturnType(String endpointName, String methodName) {
        Method method = this.getMethod(endpointName, methodName);
        if (method == null) {
            EndpointInvoker.getLogger().debug("Method '{}' not found in endpoint '{}'", (Object)methodName, (Object)endpointName);
            return null;
        }
        return method.getReturnType();
    }

    public Object invoke(String endpointName, String methodName, ObjectNode body, Principal principal, Function<String, Boolean> rolesChecker) throws EndpointInvocationException.EndpointNotFoundException, EndpointInvocationException.EndpointAccessDeniedException, EndpointInvocationException.EndpointBadRequestException, EndpointInvocationException.EndpointInternalException {
        EndpointRegistry.VaadinEndpointData vaadinEndpointData = this.endpointRegistry.get(endpointName);
        if (vaadinEndpointData == null) {
            EndpointInvoker.getLogger().debug("Endpoint '{}' not found", (Object)endpointName);
            throw new EndpointInvocationException.EndpointNotFoundException();
        }
        Method methodToInvoke = this.getMethod(endpointName, methodName);
        if (methodToInvoke == null) {
            EndpointInvoker.getLogger().debug("Method '{}' not found in endpoint '{}'", (Object)methodName, (Object)endpointName);
            throw new EndpointInvocationException.EndpointNotFoundException();
        }
        return this.invokeVaadinEndpointMethod(endpointName, methodName, methodToInvoke, body, vaadinEndpointData, principal, rolesChecker);
    }

    String createResponseErrorObject(String errorMessage) {
        ObjectNode objectNode = this.endpointMapper.createObjectNode();
        objectNode.put("message", errorMessage);
        return objectNode.toString();
    }

    String createResponseErrorObject(Map<String, Object> serializationData) throws JsonProcessingException {
        return this.endpointMapper.writeValueAsString(serializationData);
    }

    EndpointAccessChecker getAccessChecker() {
        VaadinServletContext vaadinServletContext = new VaadinServletContext(this.servletContext);
        VaadinConnectAccessCheckerWrapper wrapper = (VaadinConnectAccessCheckerWrapper)vaadinServletContext.getAttribute(VaadinConnectAccessCheckerWrapper.class, () -> {
            EndpointAccessChecker accessChecker = (EndpointAccessChecker)this.applicationContext.getBean(EndpointAccessChecker.class);
            return new VaadinConnectAccessCheckerWrapper(accessChecker);
        });
        return wrapper.accessChecker;
    }

    String writeValueAsString(Object returnValue) throws JsonProcessingException {
        return this.endpointMapper.writeValueAsString(returnValue);
    }

    private List<EndpointValidationException.ValidationErrorData> createBeanValidationErrors(Collection<ConstraintViolation<Object>> beanConstraintViolations) {
        return beanConstraintViolations.stream().map(constraintViolation -> new EndpointValidationException.ValidationErrorData(String.format("Object of type '%s' has invalid property '%s' with value '%s', validation error: '%s'", constraintViolation.getRootBeanClass(), constraintViolation.getPropertyPath().toString(), constraintViolation.getInvalidValue(), constraintViolation.getMessage()), constraintViolation.getPropertyPath().toString())).collect(Collectors.toList());
    }

    private List<EndpointValidationException.ValidationErrorData> createMethodValidationErrors(Collection<ConstraintViolation<Object>> methodConstraintViolations) {
        return methodConstraintViolations.stream().map(constraintViolation -> {
            String parameterPath = constraintViolation.getPropertyPath().toString();
            return new EndpointValidationException.ValidationErrorData(String.format("Method '%s' of the object '%s' received invalid parameter '%s' with value '%s', validation error: '%s'", parameterPath.split("\\.")[0], constraintViolation.getRootBeanClass(), parameterPath, constraintViolation.getInvalidValue(), constraintViolation.getMessage()), parameterPath);
        }).collect(Collectors.toList());
    }

    private EndpointValidationException getInvalidEndpointParametersException(String methodName, String endpointName, Map<String, String> deserializationErrors, Set<ConstraintViolation<Object>> constraintViolations) {
        ArrayList<EndpointValidationException.ValidationErrorData> validationErrorData = new ArrayList<EndpointValidationException.ValidationErrorData>(deserializationErrors.size() + constraintViolations.size());
        for (Map.Entry<String, String> deserializationError : deserializationErrors.entrySet()) {
            String message = String.format("Unable to deserialize an endpoint method parameter into type '%s'", deserializationError.getValue());
            validationErrorData.add(new EndpointValidationException.ValidationErrorData(message, deserializationError.getKey()));
        }
        validationErrorData.addAll(this.createBeanValidationErrors(constraintViolations));
        String message = String.format("Validation error in endpoint '%s' method '%s'", endpointName, methodName);
        return new EndpointValidationException(message, validationErrorData);
    }

    private Type[] getJavaParameters(Method methodToInvoke, Type classType) {
        return (Type[])Stream.of(GenericTypeReflector.getExactParameterTypes((Method)methodToInvoke, (Type)classType)).toArray(Type[]::new);
    }

    private Method getMethod(String endpointName, String methodName) {
        EndpointRegistry.VaadinEndpointData endpointData = this.endpointRegistry.get(endpointName);
        if (endpointData == null) {
            EndpointInvoker.getLogger().debug("Endpoint '{}' not found", (Object)endpointName);
            return null;
        }
        return endpointData.getMethod(methodName).orElse(null);
    }

    private Map<String, JsonNode> getRequestParameters(ObjectNode body) {
        LinkedHashMap<String, JsonNode> parametersData = new LinkedHashMap<String, JsonNode>();
        if (body != null) {
            body.fields().forEachRemaining(entry -> parametersData.put((String)entry.getKey(), (JsonNode)entry.getValue()));
        }
        return parametersData;
    }

    private Object[] getVaadinEndpointParameters(Map<String, JsonNode> requestParameters, Type[] javaParameters, String methodName, String endpointName) {
        Object[] endpointParameters = new Object[javaParameters.length];
        String[] parameterNames = new String[requestParameters.size()];
        requestParameters.keySet().toArray(parameterNames);
        HashMap<String, String> errorParams = new HashMap<String, String>();
        LinkedHashSet<ConstraintViolation<Object>> constraintViolations = new LinkedHashSet<ConstraintViolation<Object>>();
        for (int i = 0; i < javaParameters.length; ++i) {
            Type parameterType;
            Type incomingType = parameterType = javaParameters[i];
            try {
                Object parameter;
                endpointParameters[i] = parameter = this.endpointMapper.readerFor(this.endpointMapper.getTypeFactory().constructType(incomingType)).readValue(requestParameters.get(parameterNames[i]));
                if (parameter == null) continue;
                constraintViolations.addAll(this.validator.validate(parameter, new Class[0]));
                continue;
            }
            catch (IOException e) {
                String typeName = parameterType.getTypeName();
                EndpointInvoker.getLogger().error("Unable to deserialize an endpoint '{}' method '{}' parameter '{}' with type '{}'", new Object[]{endpointName, methodName, parameterNames[i], typeName, e});
                errorParams.put(parameterNames[i], typeName);
            }
        }
        if (errorParams.isEmpty() && constraintViolations.isEmpty()) {
            return endpointParameters;
        }
        throw this.getInvalidEndpointParametersException(methodName, endpointName, errorParams, constraintViolations);
    }

    private ResponseEntity<String> handleMethodExecutionError(String endpointName, String methodName, InvocationTargetException e) throws EndpointInvocationException.EndpointInternalException {
        if (EndpointException.class.isAssignableFrom(e.getCause().getClass())) {
            EndpointException endpointException = (EndpointException)e.getCause();
            EndpointInvoker.getLogger().debug("Endpoint '{}' method '{}' aborted the execution", new Object[]{endpointName, methodName, endpointException});
            throw endpointException;
        }
        String errorMessage = String.format("Endpoint '%s' method '%s' execution failure", endpointName, methodName);
        EndpointInvoker.getLogger().error(errorMessage, (Throwable)e);
        throw new EndpointInvocationException.EndpointInternalException(errorMessage);
    }

    private Object invokeVaadinEndpointMethod(String endpointName, String methodName, Method methodToInvoke, ObjectNode body, EndpointRegistry.VaadinEndpointData vaadinEndpointData, Principal principal, Function<String, Boolean> rolesChecker) throws EndpointInvocationException.EndpointAccessDeniedException, EndpointInvocationException.EndpointBadRequestException, EndpointInvocationException.EndpointInternalException {
        Object returnValue;
        EndpointAccessChecker accessChecker = this.getAccessChecker();
        String checkError = accessChecker.check(methodToInvoke, principal, rolesChecker);
        if (checkError != null) {
            throw new EndpointInvocationException.EndpointAccessDeniedException(String.format("Endpoint '%s' method '%s' request cannot be accessed, reason: '%s'", endpointName, methodName, checkError));
        }
        Map<String, JsonNode> requestParameters = this.getRequestParameters(body);
        Type[] javaParameters = this.getJavaParameters(methodToInvoke, ClassUtils.getUserClass((Object)vaadinEndpointData.getEndpointObject()));
        if (javaParameters.length != requestParameters.size()) {
            throw new EndpointInvocationException.EndpointBadRequestException(String.format("Incorrect number of parameters for endpoint '%s' method '%s', expected: %s, got: %s", endpointName, methodName, javaParameters.length, requestParameters.size()));
        }
        Object[] vaadinEndpointParameters = this.getVaadinEndpointParameters(requestParameters, javaParameters, methodName, endpointName);
        Set methodParameterConstraintViolations = this.validator.forExecutables().validateParameters(vaadinEndpointData.getEndpointObject(), methodToInvoke, vaadinEndpointParameters, new Class[0]);
        if (!methodParameterConstraintViolations.isEmpty()) {
            throw new EndpointValidationException(String.format("Validation error in endpoint '%s' method '%s'", endpointName, methodName), this.createMethodValidationErrors(methodParameterConstraintViolations));
        }
        try {
            returnValue = methodToInvoke.invoke(vaadinEndpointData.getEndpointObject(), vaadinEndpointParameters);
        }
        catch (IllegalArgumentException e) {
            String errorMessage = String.format("Received incorrect arguments for endpoint '%s' method '%s'. Expected parameter types (and their order) are: '[%s]'", endpointName, methodName, this.listMethodParameterTypes(javaParameters));
            EndpointInvoker.getLogger().debug(errorMessage, (Throwable)e);
            throw new EndpointInvocationException.EndpointBadRequestException(errorMessage);
        }
        catch (IllegalAccessException e) {
            String errorMessage = String.format("Endpoint '%s' method '%s' access failure", endpointName, methodName);
            EndpointInvoker.getLogger().error(errorMessage, (Throwable)e);
            throw new EndpointInvocationException.EndpointInternalException(errorMessage);
        }
        catch (InvocationTargetException e) {
            return this.handleMethodExecutionError(endpointName, methodName, e);
        }
        String implicitNullError = this.explicitNullableTypeChecker.checkValueForAnnotatedElement(returnValue, methodToInvoke, this.isNonNullApi(methodToInvoke.getDeclaringClass().getPackage()));
        if (implicitNullError != null) {
            String errorMessage = String.format("Unexpected return value in endpoint '%s' method '%s'. %s", endpointName, methodName, implicitNullError);
            EndpointInvoker.getLogger().error(errorMessage);
            throw new EndpointInvocationException.EndpointInternalException(errorMessage);
        }
        Set returnValueConstraintViolations = this.validator.forExecutables().validateReturnValue(vaadinEndpointData.getEndpointObject(), methodToInvoke, returnValue, new Class[0]);
        if (!returnValueConstraintViolations.isEmpty()) {
            String errorMessage = String.format("Endpoint '%s' method '%s' returned a value that has validation errors: '%s'", endpointName, methodName, returnValueConstraintViolations);
            throw new EndpointInvocationException.EndpointInternalException(errorMessage);
        }
        return returnValue;
    }

    private boolean isNonNullApi(Package pkg) {
        return Stream.of(pkg.getAnnotations()).anyMatch(ann -> ann.annotationType().getSimpleName().equals(NonNullApi.class.getSimpleName()));
    }

    private String listMethodParameterTypes(Type[] javaParameters) {
        return Stream.of(javaParameters).map(Type::getTypeName).collect(Collectors.joining(", "));
    }

    private static class VaadinConnectAccessCheckerWrapper {
        private final EndpointAccessChecker accessChecker;

        private VaadinConnectAccessCheckerWrapper(EndpointAccessChecker checker) {
            this.accessChecker = checker;
        }
    }
}

