/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.generator;

import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LiteralStringValueExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.parametrization.ResolvedTypeParametersMap;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ClassLoaderTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.github.javaparser.utils.Pair;
import com.github.javaparser.utils.SourceRoot;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import dev.hilla.Endpoint;
import dev.hilla.EndpointExposed;
import dev.hilla.EndpointNameChecker;
import dev.hilla.endpointransfermapper.EndpointTransferMapper;
import dev.hilla.generator.GeneratorType;
import dev.hilla.generator.GeneratorUtils;
import dev.hilla.generator.OpenAPIConfiguration;
import dev.hilla.generator.SchemaGenerator;
import dev.hilla.generator.SchemaResolver;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNullApi;

public class OpenAPIObjectGenerator {
    public static final String EXTENSION_VAADIN_CONNECT_PARAMETERS_DESCRIPTION = "x-vaadin-parameters-description";
    public static final String EXTENSION_VAADIN_FILE_PATH = "x-vaadin-file-path";
    public static final String CONSTRAINT_ANNOTATIONS = "x-annotations";
    private static final String EXTENSION_VAADIN_CONNECT_DEFERRABLE = "x-vaadin-connect-deferrable";
    private static final String VAADIN_CONNECT_OAUTH2_SECURITY_SCHEME = "vaadin-connect-oauth2";
    private static final String VAADIN_CONNECT_OAUTH2_TOKEN_URL = "/oauth/token";
    private final EndpointNameChecker endpointNameChecker = new EndpointNameChecker();
    private final List<Path> javaSourcePaths = new ArrayList<Path>();
    private OpenAPIConfiguration configuration;
    private Map<String, GeneratorType> usedTypes;
    private Map<ClassOrInterfaceDeclaration, String> endpointsJavadoc;
    private Map<String, TypeDeclaration<?>> nonEndpointMap;
    private Map<String, ClassOrInterfaceDeclaration> endpointExposedMap;
    private Map<String, String> qualifiedNameToPath;
    private Map<String, PathItem> pathItems;
    private Set<String> generatedSchema;
    private OpenAPI openApiModel;
    private ClassLoader typeResolverClassLoader;
    private SchemaGenerator schemaGenerator;
    private boolean needsDeferrableImport = false;
    private static EndpointTransferMapper endpointTransferMapper = new EndpointTransferMapper();
    private CombinedTypeSolver typeSolver;
    private Set<String> nonNullApiPackages = new HashSet<String>();

    private static Logger getLogger() {
        return LoggerFactory.getLogger(OpenAPIObjectGenerator.class);
    }

    public void addSourcePath(Path sourcePath) {
        if (sourcePath == null) {
            throw new IllegalArgumentException("Java source path must be a valid directory");
        }
        if (!sourcePath.toFile().exists()) {
            throw new IllegalArgumentException(String.format("Java source path '%s' doesn't exist", sourcePath));
        }
        this.javaSourcePaths.add(sourcePath);
    }

    void setTypeResolverClassLoader(ClassLoader typeResolverClassLoader) {
        this.typeResolverClassLoader = typeResolverClassLoader;
    }

    public void setOpenApiConfiguration(OpenAPIConfiguration configuration) {
        this.configuration = configuration;
    }

    public OpenAPI getOpenApi() {
        if (this.openApiModel == null) {
            this.init();
        }
        return this.openApiModel;
    }

    OpenAPI generateOpenApi() {
        this.init();
        return this.openApiModel;
    }

    Schema parseResolvedTypeToSchema(GeneratorType type, boolean requiredByContext) {
        return new SchemaResolver(type, this.usedTypes, requiredByContext).resolve();
    }

    Schema parseResolvedTypeToSchema(GeneratorType type, List<AnnotationExpr> annotations, boolean requiredByContext) {
        return new SchemaResolver(type, annotations, this.usedTypes, requiredByContext).resolve();
    }

    Class<?> getClassFromReflection(GeneratorType type) throws ClassNotFoundException {
        String fullyQualifiedName = this.getFullyQualifiedName(type);
        if (this.typeResolverClassLoader != null) {
            return Class.forName(fullyQualifiedName, true, this.typeResolverClassLoader);
        }
        return Class.forName(fullyQualifiedName);
    }

    private void init() {
        if (this.javaSourcePaths == null || this.configuration == null) {
            throw new IllegalStateException("Java source path and configuration should not be null");
        }
        this.openApiModel = this.createBasicModel();
        this.nonEndpointMap = new HashMap();
        this.endpointExposedMap = new HashMap<String, ClassOrInterfaceDeclaration>();
        this.qualifiedNameToPath = new HashMap<String, String>();
        this.pathItems = new TreeMap<String, PathItem>();
        this.usedTypes = new HashMap<String, GeneratorType>();
        this.generatedSchema = new HashSet<String>();
        this.endpointsJavadoc = new HashMap<ClassOrInterfaceDeclaration, String>();
        this.schemaGenerator = new SchemaGenerator(this);
        this.needsDeferrableImport = false;
        ParserConfiguration parserConfiguration = this.createParserConfiguration();
        this.javaSourcePaths.stream().map(path -> new SourceRoot(path, parserConfiguration)).forEach(sourceRoot -> this.parseSourceRoot((SourceRoot)sourceRoot, this::findPackageAnnotations));
        this.javaSourcePaths.stream().map(path -> new SourceRoot(path, parserConfiguration)).forEach(sourceRoot -> this.parseSourceRoot((SourceRoot)sourceRoot, this::findEndpointExposed));
        this.javaSourcePaths.stream().map(path -> new SourceRoot(path, parserConfiguration)).forEach(sourceRoot -> this.parseSourceRoot((SourceRoot)sourceRoot, this::process));
        for (Map.Entry<String, GeneratorType> entry : new ArrayList<Map.Entry<String, GeneratorType>>(this.usedTypes.entrySet())) {
            List<Schema> schemas = this.createSchemasFromQualifiedNameAndType(entry.getKey(), entry.getValue(), false);
            schemas.forEach(schema -> {
                if (this.qualifiedNameToPath.get(schema.getName()) != null) {
                    schema.addExtension(EXTENSION_VAADIN_FILE_PATH, (Object)this.qualifiedNameToPath.get(schema.getName()));
                }
                this.openApiModel.getComponents().addSchemas(schema.getName(), schema);
            });
        }
        this.addTagsInformation();
    }

    private ParserConfiguration createParserConfiguration() {
        this.typeSolver = new CombinedTypeSolver(new TypeSolver[]{new ReflectionTypeSolver(false)});
        if (this.typeResolverClassLoader != null) {
            this.typeSolver.add((TypeSolver)new ClassLoaderTypeSolver(this.typeResolverClassLoader));
        }
        JavaSymbolSolver symbolResolver = new JavaSymbolSolver((TypeSolver)this.typeSolver);
        return new ParserConfiguration().setSymbolResolver((SymbolResolver)symbolResolver).setLanguageLevel(ParserConfiguration.LanguageLevel.CURRENT);
    }

    private void parseSourceRoot(SourceRoot sourceRoot, SourceRoot.Callback callback) {
        try {
            sourceRoot.parse("", callback);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't parse the java files in the source root '%s'", sourceRoot), e);
        }
    }

    private void addTagsInformation() {
        for (Map.Entry<ClassOrInterfaceDeclaration, String> endpointJavadoc : this.endpointsJavadoc.entrySet()) {
            Tag tag = new Tag();
            ClassOrInterfaceDeclaration endpointDeclaration = endpointJavadoc.getKey();
            String simpleClassName = endpointDeclaration.getNameAsString();
            tag.name(simpleClassName);
            tag.description(endpointJavadoc.getValue());
            tag.addExtension(EXTENSION_VAADIN_FILE_PATH, (Object)this.qualifiedNameToPath.get(endpointDeclaration.getFullyQualifiedName().orElse(simpleClassName)));
            this.openApiModel.addTagsItem(tag);
        }
    }

    private OpenAPI createBasicModel() {
        OpenAPI openAPI = new OpenAPI();
        Info info = new Info();
        info.setTitle(this.configuration.getApplicationTitle());
        info.setVersion(this.configuration.getApplicationApiVersion());
        openAPI.setInfo(info);
        io.swagger.v3.oas.models.Paths paths = new io.swagger.v3.oas.models.Paths();
        openAPI.setPaths(paths);
        Server server = new Server();
        server.setUrl(this.configuration.getServerUrl());
        server.setDescription(this.configuration.getServerDescription());
        openAPI.setServers(Collections.singletonList(server));
        Components components = new Components();
        SecurityScheme vaadinConnectOAuth2Scheme = new SecurityScheme().type(SecurityScheme.Type.OAUTH2).flows(new OAuthFlows().password(new OAuthFlow().tokenUrl(VAADIN_CONNECT_OAUTH2_TOKEN_URL).scopes(new Scopes())));
        components.addSecuritySchemes(VAADIN_CONNECT_OAUTH2_SECURITY_SCHEME, vaadinConnectOAuth2Scheme);
        openAPI.components(components);
        return openAPI;
    }

    private SourceRoot.Callback.Result process(Path localPath, Path absolutePath, ParseResult<CompilationUnit> result) {
        if (!result.isSuccessful()) {
            OpenAPIObjectGenerator.getLogger().debug("Unable to parse Java file {}: {}", (Object)localPath, result);
        }
        result.ifSuccessful(compilationUnit -> ((Collection)compilationUnit.getPrimaryType().filter(BodyDeclaration::isClassOrInterfaceDeclaration).map(BodyDeclaration::asClassOrInterfaceDeclaration).filter(classOrInterfaceDeclaration -> !classOrInterfaceDeclaration.isInterface()).filter(declaration -> !GeneratorUtils.hasAnnotation(declaration, compilationUnit, EndpointExposed.class)).map(this::appendNestedClasses).orElse(Collections.emptyList())).forEach(classOrInterfaceDeclaration -> this.parseClass((TypeDeclaration<?>)classOrInterfaceDeclaration, (CompilationUnit)compilationUnit)));
        this.pathItems.forEach((pathName, pathItem) -> this.openApiModel.getPaths().addPathItem(pathName, pathItem));
        if (this.needsDeferrableImport) {
            this.openApiModel.addExtension(EXTENSION_VAADIN_CONNECT_DEFERRABLE, (Object)true);
        }
        return SourceRoot.Callback.Result.DONT_SAVE;
    }

    private SourceRoot.Callback.Result findPackageAnnotations(Path localPath, Path absolutePath, ParseResult<CompilationUnit> result) {
        result.ifSuccessful(compilationUnit -> {
            PackageDeclaration pkgDecl;
            boolean nonNullApiAnnotation;
            if (localPath.getFileName().equals(Paths.get("package-info.java", new String[0])) && (nonNullApiAnnotation = (pkgDecl = (PackageDeclaration)compilationUnit.getPackageDeclaration().get()).getAnnotations().stream().anyMatch(annotation -> NonNullApi.class.getSimpleName().equals(annotation.getName().getIdentifier())))) {
                this.nonNullApiPackages.add(pkgDecl.getNameAsString());
            }
        });
        return SourceRoot.Callback.Result.DONT_SAVE;
    }

    private SourceRoot.Callback.Result findEndpointExposed(Path localPath, Path absolutePath, ParseResult<CompilationUnit> result) {
        result.ifSuccessful(compilationUnit -> compilationUnit.getPrimaryType().filter(BodyDeclaration::isClassOrInterfaceDeclaration).map(BodyDeclaration::asClassOrInterfaceDeclaration).filter(declaration -> GeneratorUtils.hasAnnotation(declaration, compilationUnit, EndpointExposed.class)).map(declaration -> this.endpointExposedMap.put(declaration.resolve().getQualifiedName(), (ClassOrInterfaceDeclaration)declaration)));
        return SourceRoot.Callback.Result.DONT_SAVE;
    }

    private Collection<TypeDeclaration<?>> appendNestedClasses(ClassOrInterfaceDeclaration topLevelClass) {
        Set nestedClasses = topLevelClass.getMembers().stream().filter(bodyDeclaration -> bodyDeclaration.isClassOrInterfaceDeclaration() || bodyDeclaration.isEnumDeclaration()).map(bodyDeclaration -> bodyDeclaration.asTypeDeclaration()).collect(Collectors.toCollection(() -> new TreeSet<TypeDeclaration>(Comparator.comparing(NodeWithSimpleName::getNameAsString))));
        nestedClasses.add(topLevelClass);
        return nestedClasses;
    }

    private void parseClass(TypeDeclaration<?> typeDeclaration, CompilationUnit compilationUnit) {
        if (typeDeclaration.isClassOrInterfaceDeclaration()) {
            this.parseClass(typeDeclaration.asClassOrInterfaceDeclaration(), compilationUnit);
        } else if (typeDeclaration.isEnumDeclaration()) {
            EnumDeclaration enumDeclaration = typeDeclaration.asEnumDeclaration();
            compilationUnit.getStorage().ifPresent(storage -> {
                String className = enumDeclaration.getFullyQualifiedName().orElse(enumDeclaration.getNameAsString());
                this.qualifiedNameToPath.put(className, storage.getPath().toUri().toString());
            });
            this.nonEndpointMap.put(enumDeclaration.resolve().getQualifiedName(), (TypeDeclaration<?>)enumDeclaration);
        }
    }

    private void parseClass(ClassOrInterfaceDeclaration classDeclaration, CompilationUnit compilationUnit) {
        Optional endpointAnnotation = classDeclaration.getAnnotationByClass(Endpoint.class);
        compilationUnit.getStorage().ifPresent(storage -> {
            String className = classDeclaration.getFullyQualifiedName().orElse(classDeclaration.getNameAsString());
            this.qualifiedNameToPath.put(className, storage.getPath().toUri().toString());
        });
        if (!GeneratorUtils.hasAnnotation(classDeclaration, compilationUnit, Endpoint.class)) {
            this.nonEndpointMap.put(classDeclaration.resolve().getQualifiedName(), (TypeDeclaration<?>)classDeclaration);
        } else {
            Optional javadoc = classDeclaration.getJavadoc();
            if (javadoc.isPresent()) {
                this.endpointsJavadoc.put(classDeclaration, ((Javadoc)javadoc.get()).getDescription().toText());
            } else {
                this.endpointsJavadoc.put(classDeclaration, "");
            }
            this.pathItems.putAll(this.createPathItems(this.getEndpointName(classDeclaration, endpointAnnotation.orElse(null)), classDeclaration.getNameAsString(), classDeclaration, ResolvedTypeParametersMap.empty(), compilationUnit));
        }
    }

    private String getEndpointName(ClassOrInterfaceDeclaration classDeclaration, AnnotationExpr endpointAnnotation) {
        String validationError;
        String endpointValueName;
        String endpointName = Optional.ofNullable(endpointAnnotation).filter(Expression::isSingleMemberAnnotationExpr).map(Expression::asSingleMemberAnnotationExpr).map(SingleMemberAnnotationExpr::getMemberValue).map(Expression::asStringLiteralExpr).map(LiteralStringValueExpr::getValue).filter(GeneratorUtils::isNotBlank).orElse(classDeclaration.getNameAsString());
        if (endpointName.equals(classDeclaration.getNameAsString()) && endpointAnnotation != null && (endpointValueName = this.getParameterValueFromAnnotation(endpointAnnotation, "value")) != null) {
            endpointName = endpointValueName.substring(1, endpointValueName.length() - 1);
        }
        if ((validationError = this.endpointNameChecker.check(endpointName)) != null) {
            throw new IllegalStateException(String.format("Endpoint name '%s' is invalid, reason: '%s'", endpointName, validationError));
        }
        return endpointName;
    }

    private String getParameterValueFromAnnotation(AnnotationExpr endpointAnnotation, String paramName) {
        return endpointAnnotation.getChildNodes().stream().filter(node -> node.getTokenRange().isPresent() && paramName.equals(((TokenRange)node.getTokenRange().get()).getBegin().getText())).map(node -> ((TokenRange)node.getTokenRange().get()).getEnd().getText()).findFirst().orElse(null);
    }

    private List<Schema> parseNonEndpointClassAsSchema(String fullQualifiedName, boolean requiredByContext) {
        TypeDeclaration<?> typeDeclaration = this.nonEndpointMap.get(fullQualifiedName);
        if (typeDeclaration == null || typeDeclaration.isEnumDeclaration()) {
            return Collections.emptyList();
        }
        ArrayList<Schema> result = new ArrayList<Schema>();
        Schema schema = this.schemaGenerator.createSingleSchema(fullQualifiedName, typeDeclaration, requiredByContext);
        this.generatedSchema.add(fullQualifiedName);
        NodeList extendedTypes = null;
        if (typeDeclaration.isClassOrInterfaceDeclaration()) {
            extendedTypes = typeDeclaration.asClassOrInterfaceDeclaration().getExtendedTypes();
        }
        if (extendedTypes == null || extendedTypes.isEmpty()) {
            result.add(schema);
            result.addAll(this.generatedRelatedSchemas(schema, requiredByContext));
        } else {
            ComposedSchema parentSchema = new ComposedSchema();
            parentSchema.setName(fullQualifiedName);
            result.add((Schema)parentSchema);
            extendedTypes.forEach(parentType -> {
                GeneratorType type = new GeneratorType(parentType.resolve(), false);
                String parentQualifiedName = type.asResolvedType().asReferenceType().getQualifiedName();
                String parentRef = SchemaResolver.getFullQualifiedNameRef(parentQualifiedName);
                parentSchema.addAllOfItem(new ObjectSchema().$ref(parentRef));
                this.usedTypes.put(parentQualifiedName, type);
            });
            parentSchema.addAllOfItem(schema);
            result.addAll(this.generatedRelatedSchemas((Schema)parentSchema, requiredByContext));
        }
        return result;
    }

    private List<Schema> createSchemasFromQualifiedNameAndType(String qualifiedName, GeneratorType type, boolean requiredByContext) {
        List<Schema> list = this.parseNonEndpointClassAsSchema(qualifiedName, requiredByContext);
        if (list.isEmpty()) {
            return this.parseReferencedTypeAsSchema(type, requiredByContext);
        }
        return list;
    }

    private Map<String, GeneratorType> collectUsedTypesFromSchema(Schema schema) {
        HashMap<String, GeneratorType> map = new HashMap<String, GeneratorType>();
        if (GeneratorUtils.isNotBlank(schema.getName()) || GeneratorUtils.isNotBlank(schema.get$ref())) {
            String name = GeneratorUtils.firstNonBlank(schema.getName(), SchemaResolver.getSimpleRef(schema.get$ref()));
            if (this.usedTypes.containsKey(name)) {
                map.put(name, this.usedTypes.get(name));
            } else {
                OpenAPIObjectGenerator.getLogger().info("Can't find the type information of class '{}'. This might result in a missing schema in the generated OpenAPI spec.", (Object)name);
            }
        }
        if (schema instanceof ArraySchema) {
            map.putAll(this.collectUsedTypesFromSchema(((ArraySchema)schema).getItems()));
        } else if (schema instanceof MapSchema && schema.getAdditionalProperties() != null) {
            map.putAll(this.collectUsedTypesFromSchema((Schema)schema.getAdditionalProperties()));
        } else if (schema instanceof ComposedSchema && ((ComposedSchema)schema).getAllOf() != null) {
            for (Schema child : ((ComposedSchema)schema).getAllOf()) {
                map.putAll(this.collectUsedTypesFromSchema(child));
            }
        }
        if (schema.getProperties() != null) {
            schema.getProperties().values().forEach(o -> map.putAll(this.collectUsedTypesFromSchema((Schema)o)));
        }
        return map;
    }

    private boolean isReservedWord(String word) {
        return word != null && EndpointNameChecker.ECMA_SCRIPT_RESERVED_WORDS.contains(word.toLowerCase());
    }

    private Pair<ClassOrInterfaceDeclaration, ResolvedTypeParametersMap> getDeclarationAndResolvedTypeParametersMap(ClassOrInterfaceType type, ResolvedTypeParametersMap parentResolvedTypeParametersMap) {
        ResolvedReferenceType resolvedType = parentResolvedTypeParametersMap.replaceAll(type.resolve()).asReferenceType();
        String qualifiedName = resolvedType.getQualifiedName();
        ClassOrInterfaceDeclaration declaration = this.endpointExposedMap.get(qualifiedName);
        if (declaration == null) {
            return null;
        }
        return new Pair((Object)declaration, (Object)resolvedType.typeParametersMap());
    }

    private Map<String, PathItem> createPathItems(String endpointName, String tagName, ClassOrInterfaceDeclaration typeDeclaration, ResolvedTypeParametersMap resolvedTypeParametersMap, CompilationUnit compilationUnit) {
        HashMap<String, PathItem> newPathItems = new HashMap<String, PathItem>();
        List methods = typeDeclaration.getMethods();
        boolean nonNullApi = this.hasNonNullApi(compilationUnit);
        for (MethodDeclaration methodDeclaration : methods) {
            if (this.isAccessForbidden(typeDeclaration, methodDeclaration)) continue;
            String methodName = methodDeclaration.getNameAsString();
            Operation post = this.createPostOperation(methodDeclaration);
            if (methodDeclaration.getParameters().isNonEmpty()) {
                post.setRequestBody(this.createRequestBody(methodDeclaration, resolvedTypeParametersMap, nonNullApi));
            }
            ApiResponses responses = this.createApiResponses(methodDeclaration, resolvedTypeParametersMap, nonNullApi);
            post.setResponses(responses);
            post.tags(Collections.singletonList(tagName));
            PathItem pathItem = new PathItem().post(post);
            String pathName = "/" + endpointName + "/" + methodName;
            pathItem.readOperationsMap().forEach((httpMethod, operation) -> operation.setOperationId(String.join((CharSequence)"_", endpointName, methodName, httpMethod.name())));
            newPathItems.put(pathName, pathItem);
        }
        Stream.concat(typeDeclaration.getExtendedTypes().stream(), typeDeclaration.getImplementedTypes().stream()).map(resolvedType -> this.getDeclarationAndResolvedTypeParametersMap((ClassOrInterfaceType)resolvedType, resolvedTypeParametersMap)).filter(Objects::nonNull).forEach(pair -> newPathItems.putAll(this.createPathItems(endpointName, tagName, (ClassOrInterfaceDeclaration)pair.a, (ResolvedTypeParametersMap)pair.b, compilationUnit)));
        return newPathItems;
    }

    private boolean hasNonNullApi(CompilationUnit compilationUnit) {
        Optional maybePkg = compilationUnit.getPackageDeclaration();
        if (!maybePkg.isPresent()) {
            return false;
        }
        PackageDeclaration pkgDecl = (PackageDeclaration)maybePkg.get();
        return this.nonNullApiPackages.contains(pkgDecl.getNameAsString());
    }

    private boolean isAccessForbidden(ClassOrInterfaceDeclaration typeDeclaration, MethodDeclaration methodDeclaration) {
        return (!typeDeclaration.isInterface() ? !methodDeclaration.isPublic() : !methodDeclaration.isDefault()) || (this.hasSecurityAnnotation(methodDeclaration) ? methodDeclaration.isAnnotationPresent(DenyAll.class) : typeDeclaration.isAnnotationPresent(DenyAll.class));
    }

    private boolean hasSecurityAnnotation(MethodDeclaration method) {
        return method.isAnnotationPresent(AnonymousAllowed.class) || method.isAnnotationPresent(PermitAll.class) || method.isAnnotationPresent(DenyAll.class) || method.isAnnotationPresent(RolesAllowed.class);
    }

    private Operation createPostOperation(MethodDeclaration methodDeclaration) {
        Operation post = new Operation();
        SecurityRequirement securityItem = new SecurityRequirement();
        securityItem.addList(VAADIN_CONNECT_OAUTH2_SECURITY_SCHEME);
        post.addSecurityItem(securityItem);
        methodDeclaration.getJavadoc().ifPresent(javadoc -> post.setDescription(javadoc.getDescription().toText()));
        return post;
    }

    private ApiResponses createApiResponses(MethodDeclaration methodDeclaration, ResolvedTypeParametersMap resolvedTypeParametersMap, boolean nonNullApi) {
        ApiResponse successfulResponse = this.createApiSuccessfulResponse(methodDeclaration, resolvedTypeParametersMap, nonNullApi);
        ApiResponses responses = new ApiResponses();
        responses.addApiResponse("200", successfulResponse);
        return responses;
    }

    private ApiResponse createApiSuccessfulResponse(MethodDeclaration methodDeclaration, ResolvedTypeParametersMap resolvedTypeParametersMap, boolean nonNullApi) {
        Content successfulContent = new Content();
        ApiResponse successfulResponse = new ApiResponse().description("");
        methodDeclaration.getJavadoc().ifPresent(javadoc -> {
            for (JavadocBlockTag blockTag : javadoc.getBlockTags()) {
                if (blockTag.getType() != JavadocBlockTag.Type.RETURN) continue;
                successfulResponse.setDescription("Return " + blockTag.getContent().toText());
            }
        });
        if (!methodDeclaration.getType().isVoidType()) {
            MediaType mediaItem = this.createReturnMediaType(methodDeclaration, resolvedTypeParametersMap, nonNullApi);
            successfulContent.addMediaType("application/json", mediaItem);
            successfulResponse.content(successfulContent);
        }
        return successfulResponse;
    }

    private MediaType createReturnMediaType(MethodDeclaration methodDeclaration, ResolvedTypeParametersMap resolvedTypeParametersMap, boolean requiredByContext) {
        MediaType mediaItem = new MediaType();
        GeneratorType generatorType = this.createSchemaType(methodDeclaration, resolvedTypeParametersMap, requiredByContext);
        Schema schema = this.parseResolvedTypeToSchema(generatorType, (List<AnnotationExpr>)methodDeclaration.getAnnotations(), requiredByContext);
        schema.setDescription("");
        mediaItem.schema(schema);
        return mediaItem;
    }

    ResolvedType toMappedType(ResolvedType type) {
        if (!type.isReferenceType()) {
            return null;
        }
        String className = this.getFullyQualifiedName(new GeneratorType(type, false));
        String mappedClassName = endpointTransferMapper.getTransferType(className);
        if (mappedClassName == null) {
            return null;
        }
        ResolvedReferenceTypeDeclaration solved = this.typeSolver.solveType(mappedClassName);
        return new ReferenceTypeImpl(solved, new ArrayList(), (TypeSolver)this.typeSolver);
    }

    ResolvedType toMappedType(Type type) {
        Optional maybeTypeArgs;
        ResolvedType resolvedType;
        try {
            resolvedType = type.resolve();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
        if (!resolvedType.isReferenceType()) {
            return null;
        }
        String className = this.getFullyQualifiedName(new GeneratorType(type, false));
        String mappedClassName = endpointTransferMapper.getTransferType(className);
        if (mappedClassName == null) {
            return null;
        }
        ArrayList<ResolvedType> typeArguments = new ArrayList<ResolvedType>();
        if (type.isClassOrInterfaceType() && (maybeTypeArgs = type.asClassOrInterfaceType().getTypeArguments()).isPresent()) {
            NodeList typeArgs = (NodeList)maybeTypeArgs.get();
            for (Type typeArg : typeArgs) {
                typeArguments.add(typeArg.resolve());
            }
        }
        ResolvedReferenceTypeDeclaration solved = this.typeSolver.solveType(mappedClassName);
        return new ReferenceTypeImpl(solved, typeArguments, (TypeSolver)this.typeSolver);
    }

    private RequestBody createRequestBody(MethodDeclaration methodDeclaration, ResolvedTypeParametersMap resolvedTypeParametersMap, boolean requiredByContext) {
        HashMap paramsDescription = new HashMap();
        methodDeclaration.getJavadoc().ifPresent(javadoc -> {
            for (JavadocBlockTag blockTag : javadoc.getBlockTags()) {
                if (blockTag.getType() != JavadocBlockTag.Type.PARAM) continue;
                paramsDescription.put(blockTag.getName().orElse(""), blockTag.getContent().toText());
            }
        });
        RequestBody requestBody = new RequestBody();
        Content requestBodyContent = new Content();
        requestBody.content(requestBodyContent);
        MediaType requestBodyObject = new MediaType();
        requestBodyContent.addMediaType("application/json", requestBodyObject);
        ObjectSchema requestSchema = new ObjectSchema();
        requestSchema.setRequired(new ArrayList());
        requestBodyObject.schema((Schema)requestSchema);
        methodDeclaration.getParameters().forEach(arg_0 -> this.lambda$createRequestBody$32(resolvedTypeParametersMap, requiredByContext, paramsDescription, (Schema)requestSchema, arg_0));
        if (!paramsDescription.isEmpty()) {
            requestSchema.addExtension(EXTENSION_VAADIN_CONNECT_PARAMETERS_DESCRIPTION, new LinkedHashMap(paramsDescription));
        }
        return requestBody;
    }

    private GeneratorType createSchemaType(MethodDeclaration methodDeclaration, ResolvedTypeParametersMap resolvedTypeParametersMap, boolean requiredByContext) {
        Type type = methodDeclaration.getType();
        ResolvedType resolvedType = methodDeclaration.resolve().getReturnType();
        return this.createSchemaType(type, resolvedType, resolvedTypeParametersMap, requiredByContext);
    }

    private GeneratorType createSchemaType(Parameter parameter, ResolvedTypeParametersMap resolvedTypeParametersMap, boolean requiredByContext) {
        Type type = parameter.getType();
        ResolvedType resolvedType = parameter.resolve().getType();
        return this.createSchemaType(type, resolvedType, resolvedTypeParametersMap, requiredByContext);
    }

    private GeneratorType createSchemaType(Type type, ResolvedType resolvedType, ResolvedTypeParametersMap resolvedTypeParametersMap, boolean requiredByContext) {
        ResolvedType mappedType = this.toMappedType(type);
        return new GeneratorType(type, resolvedTypeParametersMap.replaceAll(mappedType == null ? resolvedType : mappedType), requiredByContext);
    }

    private List<Schema> parseReferencedTypeAsSchema(GeneratorType type, boolean requiredByContext) {
        ArrayList<Schema> results = new ArrayList<Schema>();
        Schema schema = this.schemaGenerator.createSingleSchemaFromResolvedType(type, requiredByContext);
        ResolvedReferenceType resolvedReferenceType = type.asResolvedType().asReferenceType();
        String qualifiedName = resolvedReferenceType.getQualifiedName();
        this.generatedSchema.add(qualifiedName);
        List directAncestors = resolvedReferenceType.getDirectAncestors().stream().filter(parent -> ((ResolvedReferenceTypeDeclaration)parent.getTypeDeclaration().orElseThrow(IllegalArgumentException::new)).isClass() && !Object.class.getName().equals(parent.getQualifiedName())).collect(Collectors.toList());
        if (directAncestors.isEmpty() || type.isEnum()) {
            results.add(schema);
            results.addAll(this.generatedRelatedSchemas(schema, requiredByContext));
        } else {
            ComposedSchema parentSchema = new ComposedSchema();
            parentSchema.name(qualifiedName);
            results.add((Schema)parentSchema);
            for (ResolvedReferenceType directAncestor : directAncestors) {
                String ancestorQualifiedName = directAncestor.getQualifiedName();
                String parentRef = SchemaResolver.getFullQualifiedNameRef(ancestorQualifiedName);
                parentSchema.addAllOfItem(new ObjectSchema().$ref(parentRef));
                this.usedTypes.put(ancestorQualifiedName, new GeneratorType((ResolvedType)directAncestor, type.isRequiredByContext()));
            }
            parentSchema.addAllOfItem(schema);
            results.addAll(this.generatedRelatedSchemas((Schema)parentSchema, requiredByContext));
        }
        return results;
    }

    private List<Schema> generatedRelatedSchemas(Schema schema, boolean requiredByContext) {
        ArrayList<Schema> result = new ArrayList<Schema>();
        this.collectUsedTypesFromSchema(schema).entrySet().stream().filter(s -> !this.generatedSchema.contains(s.getKey())).forEach(s -> result.addAll(this.createSchemasFromQualifiedNameAndType((String)s.getKey(), (GeneratorType)s.getValue(), requiredByContext)));
        return result;
    }

    private String getFullyQualifiedName(GeneratorType type) {
        ResolvedReferenceTypeDeclaration typeDeclaration = (ResolvedReferenceTypeDeclaration)type.asResolvedType().asReferenceType().getTypeDeclaration().orElseThrow(IllegalArgumentException::new);
        String packageName = typeDeclaration.getPackageName();
        String canonicalName = typeDeclaration.getQualifiedName();
        if (GeneratorUtils.isBlank(packageName)) {
            return GeneratorUtils.replaceChars(canonicalName, '.', '$');
        }
        String name = GeneratorUtils.substringAfterLast(canonicalName, packageName + ".");
        return String.format("%s.%s", packageName, GeneratorUtils.replaceChars(name, '.', '$'));
    }

    private /* synthetic */ void lambda$createRequestBody$32(ResolvedTypeParametersMap resolvedTypeParametersMap, boolean requiredByContext, Map paramsDescription, Schema requestSchema, Parameter parameter) {
        GeneratorType generatorType = this.createSchemaType(parameter, resolvedTypeParametersMap, requiredByContext);
        Schema paramSchema = this.parseResolvedTypeToSchema(generatorType, (List<AnnotationExpr>)parameter.getAnnotations(), requiredByContext);
        paramSchema.setDescription("");
        this.usedTypes.putAll(this.collectUsedTypesFromSchema(paramSchema));
        String name = (this.isReservedWord(parameter.getNameAsString()) ? "_" : "").concat(parameter.getNameAsString());
        if (GeneratorUtils.isBlank(paramSchema.get$ref())) {
            paramSchema.description((String)paramsDescription.remove(parameter.getNameAsString()));
        }
        requestSchema.addProperties(name, paramSchema);
        requestSchema.addRequiredItem(name);
    }
}

