/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.generator.typescript;

import com.github.jknack.handlebars.Helper;
import dev.hilla.generator.GeneratorUtils;
import dev.hilla.generator.typescript.CodeGeneratorUtils;
import dev.hilla.generator.typescript.TypeParser;
import io.swagger.codegen.v3.CodegenProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class ModelGenerator {
    private ModelGenerator() {
    }

    static Helper<CodegenProperty> getModelArgumentsHelper() {
        return (prop, options) -> ModelGenerator.getModelArguments(prop, (List)options.param(0));
    }

    static Helper<CodegenProperty> getModelFullTypeHelper() {
        return (prop, options) -> ModelGenerator.getModelFullType(CodeGeneratorUtils.getSimpleNameFromImports(prop.datatype, (List)options.param(0)));
    }

    private static List<String> getConstrainsArguments(CodegenProperty property) {
        List annotations = (List)property.getVendorExtensions().get("x-annotations");
        if (annotations != null) {
            return annotations.stream().map(annotation -> "new " + annotation).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static String getModelArguments(CodegenProperty property, List<Map<String, String>> imports) {
        String dataType = property.datatype;
        boolean optional = !property.required;
        String simpleName = CodeGeneratorUtils.getSimpleNameFromImports(dataType, imports);
        return ModelGenerator.getModelVariableArguments(simpleName, optional, ModelGenerator.getConstrainsArguments(property));
    }

    private static String getModelFullType(String name) {
        return TypeParser.parse(name).traverse().visit(new ModelTypeModelVisitor()).finish().toString();
    }

    private static String getModelVariableArguments(String name, boolean optional, List<String> constrainArguments) {
        ModelArgumentsModelVisitor visitor = new ModelArgumentsModelVisitor(optional, constrainArguments);
        TypeParser.parse(name).traverse().visit(visitor).finish();
        return visitor.getResult();
    }

    private static class ModelTypeModelVisitor
    extends ModelVisitor {
        private final Set<TypeParser.Node> visitedNodes = new HashSet<TypeParser.Node>();

        private ModelTypeModelVisitor() {
        }

        @Override
        public TypeParser.Node enter(TypeParser.Node node, TypeParser.Node parent) {
            node.setUndefined(false);
            if (this.isArray(node)) {
                TypeParser.Node newNode = new TypeParser.Node("ArrayModel");
                TypeParser.Node arrayItem = node.getNested().get(0);
                if (this.isPrimitive(arrayItem)) {
                    newNode.addNested(arrayItem);
                    this.visitedNodes.add(arrayItem);
                } else {
                    newNode.addNested(this.getModelValueType(arrayItem));
                }
                newNode.addNested(arrayItem.copy());
                this.visitedNodes.add(newNode);
                return newNode;
            }
            if (this.isObject(node) && (parent == null || !this.isObjectModel(parent))) {
                TypeParser.Node wrapper = new TypeParser.Node("ObjectModel");
                wrapper.addNested(node);
                TypeParser.Node key = node.getNested().get(0);
                TypeParser.Node value = node.getNested().get(1);
                if (this.isPrimitive(value)) {
                    node.getNested().set(1, value);
                    this.visitedNodes.add(value);
                } else {
                    node.getNested().set(1, this.getModelValueType(value));
                }
                this.visitedNodes.add(wrapper);
                this.visitedNodes.add(node);
                this.visitedNodes.add(key);
                return wrapper;
            }
            if (this.isPrimitive(node) && !this.visitedNodes.contains(node)) {
                node.setName(this.getPrimitiveModelName(node));
                this.visitedNodes.add(node);
                return node;
            }
            if (this.isAny(node) && !this.visitedNodes.contains(node)) {
                node.setName("ObjectModel");
                node.addNested(new TypeParser.Node("unknown"));
                this.visitedNodes.add(node);
                return node;
            }
            if (!this.visitedNodes.contains(node) && !this.isUnknown(node)) {
                node.setName(this.getOtherModelName(node));
            }
            return node;
        }

        private TypeParser.Node getModelValueType(TypeParser.Node node) {
            TypeParser.Node modelValueNode = new TypeParser.Node("ModelValue");
            modelValueNode.addNested(node);
            this.visitedNodes.add(modelValueNode);
            return modelValueNode;
        }
    }

    private static class ModelArgumentsModelVisitor
    extends ModelVisitor {
        private final StringBuilder builder = new StringBuilder();
        private final List<String> constrainArguments;
        private final boolean isRootOptional;

        ModelArgumentsModelVisitor(boolean isRootOptional, List<String> constrainArguments) {
            this.isRootOptional = isRootOptional;
            this.constrainArguments = constrainArguments;
        }

        @Override
        public TypeParser.Node enter(TypeParser.Node node, TypeParser.Node parent) {
            if (parent == null || this.isArray(parent)) {
                if (parent != null) {
                    this.builder.append(", ");
                }
                this.builder.append(this.prepareModelName(node));
                this.builder.append(", [");
                this.builder.append(parent == null ? this.isRootOptional : node.isUndefined());
                return node;
            }
            return null;
        }

        @Override
        public void exit(TypeParser.Node node, TypeParser.Node parent) {
            if (parent == null && !this.constrainArguments.isEmpty()) {
                this.builder.append(", ");
                this.builder.append(String.join((CharSequence)", ", this.constrainArguments));
            }
            if (parent == null || this.isArray(parent)) {
                this.builder.append("]");
            }
        }

        String getResult() {
            return this.builder.toString();
        }

        private String prepareModelName(TypeParser.Node node) {
            if (this.isArray(node)) {
                return "ArrayModel";
            }
            if (this.isObject(node) || this.isAny(node)) {
                return "ObjectModel";
            }
            if (this.isPrimitive(node)) {
                return this.getPrimitiveModelName(node);
            }
            return this.getOtherModelName(node);
        }
    }

    private static abstract class ModelVisitor
    implements TypeParser.Visitor {
        protected static final String ARRAY_MODEL_NAME = "ArrayModel";
        protected static final String OBJECT_MODEL_NAME = "ObjectModel";
        protected static final String UNKNOWN = "unknown";
        private static final String ANY = "any";
        private static final Set<String> PRIMITIVES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("string", "number", "boolean")));

        private ModelVisitor() {
        }

        protected String getOtherModelName(TypeParser.Node node) {
            return node.getName() + "Model";
        }

        protected String getPrimitiveModelName(TypeParser.Node node) {
            return GeneratorUtils.capitalize(node.getName()) + "Model";
        }

        protected boolean isArray(TypeParser.Node node) {
            return Objects.equals(node.getName(), "Array");
        }

        protected boolean isObject(TypeParser.Node node) {
            return Objects.equals(node.getName(), "Record");
        }

        protected boolean isObjectModel(TypeParser.Node node) {
            return Objects.equals(node.getName(), OBJECT_MODEL_NAME);
        }

        protected boolean isPrimitive(TypeParser.Node node) {
            return PRIMITIVES.contains(node.getName());
        }

        protected boolean isAny(TypeParser.Node node) {
            return Objects.equals(node.getName(), ANY);
        }

        protected boolean isUnknown(TypeParser.Node node) {
            return Objects.equals(node.getName(), UNKNOWN);
        }
    }
}

