/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.generator.typescript;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class TypeParser {
    private TypeParser() {
    }

    static Node parse(String type) {
        Objects.requireNonNull(type);
        List<Token> tokens = Token.process(type);
        Node root = Node.process(tokens);
        if (root == null) {
            throw new ParsingError(String.format("'%s' is not a type", type));
        }
        return root;
    }

    private static abstract class Token {
        private static final char CLOSE_BRACE = '>';
        private static final char COMMA = ',';
        private static final char OPEN_BRACE = '<';
        private static final char PIPE = '|';
        private static final char SPACE = ' ';

        private Token() {
        }

        static List<Token> process(CharSequence sequence) {
            ArrayList<Token> tokens = new ArrayList<Token>();
            NameToken token = null;
            block7: for (int i = 0; i < sequence.length(); ++i) {
                char ch = sequence.charAt(i);
                switch (ch) {
                    case ' ': {
                        continue block7;
                    }
                    case '|': {
                        tokens.add(new PipeToken());
                        token = null;
                        continue block7;
                    }
                    case '<': {
                        tokens.add(new BraceToken(false));
                        token = null;
                        continue block7;
                    }
                    case '>': {
                        tokens.add(new BraceToken(true));
                        token = null;
                        continue block7;
                    }
                    case ',': {
                        token = null;
                        continue block7;
                    }
                    default: {
                        if (token == null) {
                            token = new NameToken();
                            tokens.add(token);
                        }
                        token.append(ch);
                    }
                }
            }
            return tokens;
        }
    }

    static class Node {
        private String name;
        private List<Node> nested = new ArrayList<Node>();
        private boolean undefined = false;

        Node(String name) {
            this.name = name;
        }

        private static Node process(List<Token> tokens) {
            ArrayDeque<Node> unclosedNodes = new ArrayDeque<Node>();
            Node currentNode = null;
            boolean waitingForSuffix = false;
            for (Token token : tokens) {
                if (token instanceof NameToken) {
                    if (currentNode != null && waitingForSuffix) {
                        if (Objects.equals(((NameToken)token).getName(), "undefined")) {
                            currentNode.setUndefined(true);
                            waitingForSuffix = false;
                            continue;
                        }
                        throw new ParsingError(String.format("Type union '%s | %s' is not expected", currentNode.getName(), ((NameToken)token).getName()));
                    }
                    currentNode = new Node(((NameToken)token).getName());
                    if (unclosedNodes.isEmpty()) continue;
                    ((Node)unclosedNodes.peek()).addNested(currentNode);
                    continue;
                }
                if (token instanceof PipeToken) {
                    waitingForSuffix = true;
                    continue;
                }
                if (((BraceToken)token).isClosing()) {
                    currentNode = (Node)unclosedNodes.pop();
                    continue;
                }
                if (currentNode == null) {
                    throw new ParsingError("Type open brace (<) cannot go before the type name");
                }
                unclosedNodes.push(currentNode);
            }
            return currentNode;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.name);
            if (!this.nested.isEmpty()) {
                builder.append('<');
                builder.append(this.nested.stream().map(Node::toString).collect(Collectors.joining(", ")));
                builder.append('>');
            }
            if (this.undefined) {
                builder.append(" | undefined");
            }
            return builder.toString();
        }

        void addNested(Node node) {
            this.nested.add(node);
        }

        Node copy() {
            Node copy = new Node(this.name);
            copy.setNested(this.nested.stream().map(Node::copy).collect(Collectors.toList()));
            copy.setUndefined(this.undefined);
            return copy;
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        List<Node> getNested() {
            return this.nested;
        }

        void setNested(List<Node> nested) {
            this.nested = nested;
        }

        boolean hasNested() {
            return !this.nested.isEmpty();
        }

        boolean isUndefined() {
            return this.undefined;
        }

        void setUndefined(boolean undefined) {
            this.undefined = undefined;
        }

        Traverse traverse() {
            return new Traverse(this);
        }
    }

    static class ParsingError
    extends Error {
        ParsingError(String message) {
            super(message);
        }
    }

    private static class PipeToken
    extends Token {
        private PipeToken() {
        }
    }

    private static class NameToken
    extends Token {
        private final StringBuilder name = new StringBuilder();

        private NameToken() {
        }

        void append(char ch) {
            this.name.append(ch);
        }

        String getName() {
            return this.name.toString();
        }
    }

    private static class BraceToken
    extends Token {
        private final boolean closing;

        BraceToken(boolean closing) {
            this.closing = closing;
        }

        boolean isClosing() {
            return this.closing;
        }
    }

    static class Traverse {
        private final Node root;
        private final List<Visitor> visitors = new ArrayList<Visitor>();

        Traverse(Node root) {
            this.root = root;
        }

        Node finish() {
            return this.applyVisitors(this.root, null);
        }

        Traverse visit(Visitor visitor) {
            this.visitors.add(visitor);
            return this;
        }

        private Node applyVisitors(Node node, Node parent) {
            Node tmp = node;
            for (Visitor visitor : this.visitors) {
                tmp = visitor.enter(tmp, parent);
                if (tmp != null) continue;
                return null;
            }
            this.visit(tmp);
            for (Visitor visitor : this.visitors) {
                visitor.exit(tmp, parent);
            }
            return tmp;
        }

        private void visit(Node node) {
            if (node.hasNested()) {
                node.setNested(node.nested.stream().map(n -> this.applyVisitors((Node)n, node)).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        }
    }

    static interface Visitor {
        default public Node enter(Node node, Node parent) {
            return node;
        }

        default public void exit(Node node, Node parent) {
        }
    }
}

