/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.springnative;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import dev.hilla.push.PushEndpoint;
import dev.hilla.push.messages.fromclient.AbstractServerMessage;
import dev.hilla.push.messages.toclient.AbstractClientMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;

public class HillaHintsRegistrar
implements RuntimeHintsRegistrar {
    private static final String openApiResourceName = "/dev/hilla/openapi.json";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        this.registerEndpointTypes(hints);
        hints.reflection().registerType(PushEndpoint.class, MemberCategory.values());
        ArrayList pushMessageTypes = new ArrayList();
        pushMessageTypes.addAll(this.getMessageTypes(AbstractServerMessage.class));
        pushMessageTypes.addAll(this.getMessageTypes(AbstractClientMessage.class));
        for (Class clazz : pushMessageTypes) {
            hints.reflection().registerType(clazz, MemberCategory.values());
        }
    }

    private void registerEndpointTypes(RuntimeHints hints) {
        try {
            URL resource = this.getClass().getResource(openApiResourceName);
            if (resource == null) {
                this.logger.error("Resource {} is not available", (Object)openApiResourceName);
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream()));
            String openApiAsText = reader.lines().collect(Collectors.joining("\n"));
            List<Class<?>> types = HillaHintsRegistrar.parseOpenApi(openApiAsText);
            for (Class<?> type : types) {
                hints.reflection().registerType(type, MemberCategory.values());
            }
        }
        catch (IOException e) {
            this.logger.error("Error while scanning and registering endpoint types", (Throwable)e);
        }
    }

    public static List<Class<?>> parseOpenApi(String openApiAsText) throws IOException {
        JsonNode openApi = new ObjectMapper().readTree(openApiAsText);
        ObjectNode schemas = (ObjectNode)openApi.get("components").get("schemas");
        ArrayList types = new ArrayList();
        schemas.fieldNames().forEachRemaining(type -> {
            block4: {
                try {
                    types.add(Class.forName(type));
                }
                catch (ClassNotFoundException e) {
                    int lastDot = type.lastIndexOf(46);
                    if (lastDot < 0) break block4;
                    String modifiedName = type.substring(0, lastDot) + "$" + type.substring(lastDot + 1);
                    try {
                        types.add(Class.forName(modifiedName));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
        });
        return types;
    }

    private Collection<Class<?>> getMessageTypes(Class<?> cls) {
        ArrayList classes = new ArrayList();
        classes.add(cls);
        JsonSubTypes subTypes = cls.getAnnotation(JsonSubTypes.class);
        for (JsonSubTypes.Type t : subTypes.value()) {
            classes.add(t.value());
        }
        return classes;
    }
}

