/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.push;

import dev.hilla.EndpointInvoker;
import dev.hilla.push.PushEndpoint;
import dev.hilla.push.PushMessageHandler;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.atmosphere.client.TrackMessageSizeInterceptor;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.ContainerInitializer;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.atmosphere.interceptor.SuspendTrackerInterceptor;
import org.atmosphere.util.SimpleBroadcaster;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PushConfigurer {
    @Bean
    PushEndpoint pushEndpoint() {
        return new PushEndpoint();
    }

    @Bean
    PushMessageHandler pushMessageHandler(EndpointInvoker endpointInvoker) {
        return new PushMessageHandler(endpointInvoker);
    }

    @Bean
    EmbeddedAtmosphereInitializer atmosphereInitializer() {
        return new EmbeddedAtmosphereInitializer();
    }

    @Bean
    ServletRegistrationBean<AtmosphereServlet> atmosphereServlet(PushEndpoint pushEndpoint) {
        AtmosphereServlet atmosphereServlet = new AtmosphereServlet();
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)atmosphereServlet, new String[]{"/HILLA/push"});
        List<AtmosphereInterceptor> interceptors = Arrays.asList(new AtmosphereResourceLifecycleInterceptor(), new TrackMessageSizeInterceptor(), new SuspendTrackerInterceptor());
        AtmosphereFramework fw = atmosphereServlet.framework();
        fw.setDefaultBroadcasterClassName(SimpleBroadcaster.class.getName());
        fw.addAtmosphereHandler("/HILLA/push", (AtmosphereHandler)pushEndpoint, interceptors);
        registration.addInitParameter("org.atmosphere.container.JSR356AsyncSupport.mappingPath", "/HILLA/push");
        registration.setLoadOnStartup(0);
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }

    static class EmbeddedAtmosphereInitializer
    extends ContainerInitializer
    implements ServletContextInitializer {
        EmbeddedAtmosphereInitializer() {
        }

        public void onStartup(ServletContext servletContext) throws ServletException {
            this.onStartup(Collections.emptySet(), servletContext);
        }
    }
}

