/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.crud;

import dev.hilla.crud.filter.PropertyStringFilter;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.springframework.data.jpa.domain.Specification;

public class PropertyStringFilterSpecification<T>
implements Specification<T> {
    private final PropertyStringFilter filter;
    private final Class<?> javaType;

    public PropertyStringFilterSpecification(PropertyStringFilter filter, Class<?> javaType) {
        this.filter = filter;
        this.javaType = javaType;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        String value = this.filter.getFilterValue();
        Path<String> propertyPath = this.getPath(this.filter.getPropertyId(), root);
        if (this.javaType == String.class) {
            Expression expr = criteriaBuilder.lower(propertyPath);
            switch (this.filter.getMatcher()) {
                case EQUALS: {
                    return criteriaBuilder.equal(expr, (Object)value.toLowerCase());
                }
                case CONTAINS: {
                    return criteriaBuilder.like(expr, "%" + value.toLowerCase() + "%");
                }
                case GREATER_THAN: {
                    throw new IllegalArgumentException("A string cannot be filtered using greater than");
                }
                case LESS_THAN: {
                    throw new IllegalArgumentException("A string cannot be filtered using less than");
                }
            }
        } else if (this.isNumber(this.javaType)) {
            switch (this.filter.getMatcher()) {
                case EQUALS: {
                    return criteriaBuilder.equal(propertyPath, (Object)value);
                }
                case CONTAINS: {
                    throw new IllegalArgumentException("A number cannot be filtered using contains");
                }
                case GREATER_THAN: {
                    return criteriaBuilder.greaterThan(propertyPath, (Comparable)((Object)value));
                }
                case LESS_THAN: {
                    return criteriaBuilder.lessThan(propertyPath, (Comparable)((Object)value));
                }
            }
        } else if (this.isBoolean(this.javaType)) {
            Boolean booleanValue = Boolean.valueOf(value);
            switch (this.filter.getMatcher()) {
                case EQUALS: {
                    return criteriaBuilder.equal(propertyPath, (Object)booleanValue);
                }
                case CONTAINS: {
                    throw new IllegalArgumentException("A boolean cannot be filtered using contains");
                }
                case GREATER_THAN: {
                    throw new IllegalArgumentException("A boolean cannot be filtered using greater than");
                }
                case LESS_THAN: {
                    throw new IllegalArgumentException("A boolean cannot be filtered using less than");
                }
            }
        } else if (this.isLocalDate(this.javaType)) {
            Path path = root.get(this.filter.getPropertyId());
            LocalDate dateValue = LocalDate.parse(value);
            switch (this.filter.getMatcher()) {
                case EQUALS: {
                    return criteriaBuilder.equal((Expression)path, (Object)dateValue);
                }
                case CONTAINS: {
                    throw new IllegalArgumentException("A date cannot be filtered using contains");
                }
                case GREATER_THAN: {
                    return criteriaBuilder.greaterThan((Expression)path, (Comparable)dateValue);
                }
                case LESS_THAN: {
                    return criteriaBuilder.lessThan((Expression)path, (Comparable)dateValue);
                }
            }
        } else if (this.isLocalTime(this.javaType)) {
            Path path = root.get(this.filter.getPropertyId());
            LocalTime timeValue = LocalTime.parse(value);
            switch (this.filter.getMatcher()) {
                case EQUALS: {
                    return criteriaBuilder.equal((Expression)path, (Object)timeValue);
                }
                case CONTAINS: {
                    throw new IllegalArgumentException("A time cannot be filtered using contains");
                }
                case GREATER_THAN: {
                    return criteriaBuilder.greaterThan((Expression)path, (Comparable)timeValue);
                }
                case LESS_THAN: {
                    return criteriaBuilder.lessThan((Expression)path, (Comparable)timeValue);
                }
            }
        } else if (this.isLocalDateTime(this.javaType)) {
            Path path = root.get(this.filter.getPropertyId());
            LocalDate dateValue = LocalDate.parse(value);
            LocalDateTime minValue = LocalDateTime.of(dateValue, LocalTime.MIN);
            LocalDateTime maxValue = LocalDateTime.of(dateValue, LocalTime.MAX);
            switch (this.filter.getMatcher()) {
                case EQUALS: {
                    return criteriaBuilder.between((Expression)path, (Comparable)minValue, (Comparable)maxValue);
                }
                case CONTAINS: {
                    throw new IllegalArgumentException("A datetime cannot be filtered using contains");
                }
                case GREATER_THAN: {
                    return criteriaBuilder.greaterThan((Expression)path, (Comparable)maxValue);
                }
                case LESS_THAN: {
                    return criteriaBuilder.lessThan((Expression)path, (Comparable)minValue);
                }
            }
        } else if (this.javaType.isEnum()) {
            Enum enumValue = Enum.valueOf(this.javaType.asSubclass(Enum.class), value);
            switch (this.filter.getMatcher()) {
                case EQUALS: {
                    return criteriaBuilder.equal(propertyPath, (Object)enumValue);
                }
                case CONTAINS: {
                    throw new IllegalArgumentException("An enum cannot be filtered using contains");
                }
                case GREATER_THAN: {
                    throw new IllegalArgumentException("An enum cannot be filtered using greater than");
                }
                case LESS_THAN: {
                    throw new IllegalArgumentException("An enum cannot be filtered using less than");
                }
            }
        }
        throw new IllegalArgumentException("No implementation for " + this.javaType + " using " + this.filter.getMatcher() + ".");
    }

    private boolean isNumber(Class<?> javaType) {
        return javaType == Integer.TYPE || javaType == Integer.class || javaType == Long.TYPE || javaType == Long.class || javaType == Float.TYPE || javaType == Float.class || javaType == Double.TYPE || javaType == Double.class;
    }

    private Path<String> getPath(String propertyId, Root<T> root) {
        String[] parts = propertyId.split("\\.");
        Path path = root.get(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            path = path.get(parts[i]);
        }
        return path;
    }

    private boolean isBoolean(Class<?> javaType) {
        return javaType == Boolean.TYPE || javaType == Boolean.class;
    }

    private boolean isLocalDate(Class<?> javaType) {
        return javaType == LocalDate.class;
    }

    private boolean isLocalTime(Class<?> javaType) {
        return javaType == LocalTime.class;
    }

    private boolean isLocalDateTime(Class<?> javaType) {
        return javaType == LocalDateTime.class;
    }
}

