/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla;

import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.Platform;
import dev.hilla.EndpointController;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HillaStats {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointController.class);

    HillaStats() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> getHillaReactVersion() {
        try (InputStream pomProperties = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/maven/dev.hilla/hilla-react/pom.properties");){
            if (pomProperties != null) {
                Properties properties = new Properties();
                properties.load(pomProperties);
                Optional<String> optional2 = Optional.of(properties.getProperty("version", ""));
                return optional2;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
        catch (Exception e) {
            LOGGER.error("Unable to determine dev.hilla/hilla-react version", (Throwable)e);
            return Optional.of("?");
        }
    }

    private static Optional<String> getHillaLitVersion() {
        Optional<String> hillaReactVersion = HillaStats.getHillaReactVersion();
        return hillaReactVersion.isPresent() ? Optional.empty() : Platform.getHillaVersion();
    }

    public static void report() {
        UsageStatistics.markAsUsed((String)"hilla", (String)Platform.getHillaVersion().orElse("?"));
        Optional<String> hillaReactVersion = HillaStats.getHillaReactVersion();
        hillaReactVersion.ifPresent(version -> UsageStatistics.markAsUsed((String)"hilla+react", (String)version));
        Optional<String> hillaLitVersion = HillaStats.getHillaLitVersion();
        hillaLitVersion.ifPresent(version -> UsageStatistics.markAsUsed((String)"hilla+lit", (String)version));
    }
}

