/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla;

import dev.hilla.BrowserCallable;
import dev.hilla.Endpoint;
import dev.hilla.EndpointCodeGenerator;
import dev.hilla.EndpointExposed;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hotswapper {
    private static boolean inUse;

    private static Logger getLogger() {
        return LoggerFactory.getLogger(Hotswapper.class);
    }

    public static void onHotswap(Boolean redefined, String[] changedClasses) {
        try {
            if (Hotswapper.isIgnoredClasses(changedClasses)) {
                return;
            }
            if (Hotswapper.affectsEndpoints(changedClasses)) {
                if (Hotswapper.getLogger().isDebugEnabled()) {
                    String changed = List.of(changedClasses).toString();
                    String operation = redefined != false ? "updated" : "added";
                    Hotswapper.getLogger().debug("Regenerating endpoints because " + changed + " were " + operation);
                }
                EndpointCodeGenerator.getInstance().update();
            }
        }
        catch (IOException e) {
            Hotswapper.getLogger().error("Failed to re-generated TypeScript code");
        }
    }

    private static boolean isIgnoredClasses(String[] changedClasses) {
        for (String changedClass : changedClasses) {
            if (Hotswapper.isIgnoredClass(changedClass)) continue;
            return false;
        }
        return true;
    }

    private static boolean isIgnoredClass(String changedClass) {
        return changedClass.startsWith("java.") || changedClass.startsWith("javax.") || changedClass.startsWith("sun.") || changedClass.startsWith("com.sun.") || changedClass.startsWith("dev.hilla.parser.") || changedClass.startsWith("dev.hilla.engine.") || changedClass.startsWith("com.vaadin.flow.") || changedClass.startsWith("com.vaadin.base.") || changedClass.startsWith("org.jsoup.") || changedClass.startsWith("io.github.classgraph.") || changedClass.startsWith("io.swagger.") || changedClass.startsWith("com.fasterxml.jackson.") || changedClass.startsWith("elemental.json.") || changedClass.startsWith("org.springframework.") || changedClass.startsWith("org.atmosphere.") || changedClass.startsWith("org.apache.commons.") || changedClass.startsWith("org.apache.coyote.") || changedClass.startsWith("org.apache.catalina.") || changedClass.startsWith("org.apache.tomcat.") || changedClass.startsWith("org.hotswap.") || changedClass.startsWith("jakarta.") || changedClass.startsWith("io.gprc.") || changedClass.startsWith("io.netty.") || changedClass.startsWith("com.google.gson.") || changedClass.startsWith("nonapi.io.github.classgraph.") || changedClass.startsWith("jdk.") || changedClass.equals("com.vaadin.base.devserver.viteproxy.ViteWebsocketProxy");
    }

    private static boolean affectsEndpoints(String[] changedClasses) throws IOException {
        Set<String> changedClassesSet = Set.of(changedClasses);
        Set<String> classesUsedInEndpoints = EndpointCodeGenerator.getInstance().getClassesUsedInOpenApi();
        for (String classUsedInEndpoints : classesUsedInEndpoints) {
            if (!changedClassesSet.contains(classUsedInEndpoints)) continue;
            Hotswapper.getLogger().debug("The changed class " + classesUsedInEndpoints + " is used in an endpoint");
            return true;
        }
        for (String changedClass : changedClasses) {
            try {
                Class<?> cls = Class.forName(changedClass);
                if (cls.getAnnotation(Endpoint.class) == null && cls.getAnnotation(BrowserCallable.class) == null && cls.getAnnotation(EndpointExposed.class) == null) continue;
                Hotswapper.getLogger().debug("An endpoint annotation has been added to the class " + classesUsedInEndpoints);
                return true;
            }
            catch (ClassNotFoundException e) {
                Hotswapper.getLogger().error("Unable to find class " + changedClass, (Throwable)e);
            }
        }
        return false;
    }

    public static void markInUse() {
        inUse = true;
    }

    public static boolean isInUse() {
        return inUse;
    }
}

