/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.auth;

import com.vaadin.flow.internal.springcsrf.SpringCsrfTokenUtil;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import com.vaadin.flow.server.communication.IndexHtmlResponse;
import jakarta.servlet.http.Cookie;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;

public class CsrfIndexHtmlRequestListener
implements IndexHtmlRequestListener {
    public void modifyIndexHtmlResponse(IndexHtmlResponse indexHtmlResponse) {
        this.ensureCsrfTokenCookieIsSet(indexHtmlResponse.getVaadinRequest(), indexHtmlResponse.getVaadinResponse());
    }

    private void ensureCsrfTokenCookieIsSet(VaadinRequest request, VaadinResponse response) {
        if (this.isSpringCsrfTokenPresent(request)) {
            return;
        }
        String csrfCookieValue = Optional.ofNullable(request.getCookies()).map(Arrays::stream).orElse(Stream.empty()).filter(cookie -> cookie.getName().equals("csrfToken")).findFirst().map(Cookie::getValue).orElse(null);
        if (csrfCookieValue != null && !csrfCookieValue.isEmpty()) {
            return;
        }
        String csrfToken = UUID.randomUUID().toString();
        Cookie csrfCookie = new Cookie("csrfToken", csrfToken);
        csrfCookie.setSecure(request.isSecure());
        String path = request.getContextPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        csrfCookie.setPath(path);
        csrfCookie.setHttpOnly(false);
        response.addCookie(csrfCookie);
    }

    boolean isSpringCsrfTokenPresent(VaadinRequest request) {
        return SpringCsrfTokenUtil.getSpringCsrfToken((VaadinRequest)request).isPresent();
    }
}

