/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.internal.hotswap;

import dev.hilla.Hotswapper;
import dev.hilla.internal.hotswap.EndpointHotSwapListener;
import dev.hilla.internal.hotswap.EndpointHotSwapService;
import dev.hilla.internal.hotswap.HotSwapConfigurationProperties;
import dev.hilla.internal.hotswap.HotSwapServiceInitializer;
import dev.hilla.internal.hotswap.PollChangedEndpointsHotSwapService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HotSwapConfiguration {
    @Bean
    @ConfigurationProperties(prefix="hilla.endpoint.hot-reload")
    public HotSwapConfigurationProperties hotSwapConfigurationProperties() {
        return new HotSwapConfigurationProperties();
    }

    @Bean
    EndpointHotSwapService hotSwapWatchService(@Autowired HotSwapConfigurationProperties configurationProperties) {
        return new PollChangedEndpointsHotSwapService(configurationProperties.getPollInterval());
    }

    @Bean
    HotSwapServiceInitializer hotSwapServiceInitializer(@Autowired EndpointHotSwapService endpointHotSwapService, @Autowired HotSwapConfigurationProperties configurationProperties) {
        return new HotSwapServiceInitializer(endpointHotSwapService, configurationProperties.isEnabled() && !Hotswapper.isInUse());
    }

    @Bean
    EndpointHotSwapListener endpointHotSwapListener(@Autowired EndpointHotSwapService endpointHotSwapService) {
        return new EndpointHotSwapListener(endpointHotSwapService);
    }
}

