/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.engine;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.hilla.engine.ConfigurationException;
import dev.hilla.engine.GeneratorConfiguration;
import dev.hilla.engine.ParserConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Objects;

public class EngineConfiguration {
    public static final String RESOURCE_NAME = "hilla-engine-configuration.json";
    public static final String OPEN_API_PATH = "dev/hilla/openapi.json";
    private static final ObjectMapper MAPPER = new ObjectMapper().setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    private Path baseDir;
    private LinkedHashSet<String> classPath;
    private GeneratorConfiguration generator;
    private ParserConfiguration parser;
    private String buildDir;
    private String classesDir;
    private String outputDir = "frontend/generated";

    public static EngineConfiguration load(File targetDir) throws IOException {
        File configFile = new File(targetDir, RESOURCE_NAME);
        if (!configFile.isFile()) {
            return null;
        }
        configFile.deleteOnExit();
        try {
            return (EngineConfiguration)MAPPER.readValue(configFile, EngineConfiguration.class);
        }
        catch (RuntimeException e) {
            throw new ConfigurationException(e);
        }
    }

    public void store(File targetDir) throws IOException {
        MAPPER.writeValue(new File(targetDir, RESOURCE_NAME), (Object)this);
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(Path baseDir) {
        this.baseDir = baseDir;
    }

    public LinkedHashSet<String> getClassPath() {
        return this.classPath;
    }

    public void setClassPath(LinkedHashSet<String> classPath) {
        this.classPath = classPath;
    }

    public GeneratorConfiguration getGenerator() {
        return this.generator;
    }

    public void setGenerator(GeneratorConfiguration generator) {
        this.generator = generator;
    }

    public ParserConfiguration getParser() {
        return this.parser;
    }

    public void setParser(ParserConfiguration parser) {
        this.parser = parser;
    }

    public String getBuildDir() {
        return this.buildDir;
    }

    public void setBuildDir(String buildDir) {
        this.buildDir = buildDir;
    }

    public String getClassesDir() {
        return this.classesDir;
    }

    public void setClassesDir(String classesDir) {
        this.classesDir = classesDir;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public void setOutputDir(Path outputDir) {
        if (outputDir.isAbsolute()) {
            this.setOutputDir(this.baseDir.toAbsolutePath().relativize(outputDir.toAbsolutePath()).toString());
        } else {
            this.setOutputDir(outputDir.toString());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EngineConfiguration that = (EngineConfiguration)o;
        return Objects.equals(this.baseDir, that.baseDir) && Objects.equals(this.classPath, that.classPath) && Objects.equals(this.generator, that.generator) && Objects.equals(this.parser, that.parser) && Objects.equals(this.buildDir, that.buildDir) && Objects.equals(this.classesDir, that.classesDir) && Objects.equals(this.outputDir, that.outputDir);
    }

    public int hashCode() {
        return Objects.hash(this.baseDir, this.classPath, this.generator, this.parser, this.buildDir, this.classesDir, this.outputDir);
    }

    Path getOpenAPIFile() {
        return this.baseDir.resolve(this.classesDir).resolve(OPEN_API_PATH);
    }

    Path getOutputDirectory() {
        return this.baseDir.resolve(this.outputDir);
    }
}

