/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.engine;

import com.vaadin.flow.server.frontend.FrontendUtils;
import dev.hilla.engine.GeneratorException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GeneratorShellRunner {
    private static final boolean IS_WINDOWS = FrontendUtils.isWindows();
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneratorShellRunner.class);
    private static final Path TSGEN_PATH = Paths.get("node_modules", "@hilla", "generator-typescript-cli", "bin", "index.js");
    private final List<String> arguments = new ArrayList<String>();
    private final File rootDirectory;

    public GeneratorShellRunner(File rootDirectory, String nodeCommand) {
        this.rootDirectory = rootDirectory;
        if (IS_WINDOWS) {
            this.arguments.add("cmd.exe");
            this.arguments.add("/c");
        }
        this.arguments.add(nodeCommand);
        this.arguments.add(TSGEN_PATH.toString());
    }

    public void add(String ... args) {
        this.arguments.addAll(List.of(args));
    }

    public void run(String input) throws InterruptedException, IOException {
        Objects.requireNonNull(input);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing command: {}", (Object)String.join((CharSequence)" ", this.arguments));
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]).directory(this.rootDirectory).command(this.arguments).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT);
        Process process = builder.start();
        try (OutputStream stdin = process.getOutputStream();){
            stdin.write(input.getBytes(StandardCharsets.UTF_8));
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new GeneratorException("Generator execution failed with exit code " + exitCode);
        }
        LOGGER.info("The Generator process finished with the exit code {}", (Object)exitCode);
    }
}

